/// <reference path="./internal_*.d.ts" />
declare namespace com.simibubi.create.foundation.mixin.accessor {
    interface LevelRendererAccessor {
        abstract create$getCullingFrustum(): Internal.Frustum;
        abstract create$getCapturedFrustum(): Internal.Frustum;
    }
    type LevelRendererAccessor_ = LevelRendererAccessor;
}
declare namespace com.tterrag.registrate.builders {
    class FluidBuilder <T extends com.tterrag.registrate.fabric.SimpleFlowableFluid, P> extends Internal.AbstractBuilder<Internal.Fluid, T, P, com.tterrag.registrate.builders.FluidBuilder<T, P>> {
        constructor(owner: Internal.AbstractRegistrate_<any>, parent: P, name: string, callback: Internal.BuilderCallback_, stillTexture: ResourceLocation_, flowingTexture: ResourceLocation_, fluidFactory: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.SimpleFlowableFluid$Properties, T>)
        block1<B extends Internal.LiquidBlock>(factory: Internal.NonNullBiFunction_<T, Internal.BlockBehaviour$Properties, B>): com.tterrag.registrate.builders.BlockBuilder<B, com.tterrag.registrate.builders.FluidBuilder<T, P>>;
        lang(name: string): this;
        tag(...tags: Internal.TagKey_<Internal.Fluid>[]): this;
        static of<T>(sup: Internal.Supplier_<T>, errorMsg: Internal.NonNullSupplier_<string>): Internal.NonNullSupplier<T>;
        bucket<I extends Internal.BucketItem>(factory: Internal.NonNullBiFunction_<com.tterrag.registrate.fabric.SimpleFlowableFluid, Internal.Item$Properties, I>): com.tterrag.registrate.builders.ItemBuilder<I, com.tterrag.registrate.builders.FluidBuilder<T, P>>;
        source(factory: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.SimpleFlowableFluid$Properties, com.tterrag.registrate.fabric.SimpleFlowableFluid>): this;
        bucket(): com.tterrag.registrate.builders.ItemBuilder<Internal.BucketItem, com.tterrag.registrate.builders.FluidBuilder<T, P>>;
        onRegister(callback: com.tterrag.registrate.util.nullness.NonNullConsumer_<T>): this;
        static create<T extends com.tterrag.registrate.fabric.SimpleFlowableFluid, P>(owner: Internal.AbstractRegistrate_<any>, parent: P, name: string, callback: Internal.BuilderCallback_, stillTexture: ResourceLocation_, flowingTexture: ResourceLocation_, fluidFactory: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.SimpleFlowableFluid$Properties, T>): com.tterrag.registrate.builders.FluidBuilder<T, P>;
        renderType(layer: Internal.Supplier_<Internal.Supplier<Internal.RenderType>>): this;
        transform<R2, T2 extends R2, P2, S2 extends Internal.Builder<R2, T2, P2, S2>>(func: com.tterrag.registrate.util.nullness.NonNullFunction_<com.tterrag.registrate.builders.FluidBuilder<T, P>, S2>): S2;
        addMiscData<D extends Internal.RegistrateProvider>(type: Internal.ProviderType_<D>, cons: com.tterrag.registrate.util.nullness.NonNullConsumer_<D>): this;
        register(): Internal.RegistryEntry<any>;
        defaultBlock(): this;
        getEntry(): T;
        fluidAttributes(handler: Internal.NonNullSupplier_<Internal.FluidVariantAttributeHandler>): this;
        build(): P;
        fluidProperties(cons: com.tterrag.registrate.util.nullness.NonNullConsumer_<Internal.SimpleFlowableFluid$Properties>): this;
        defaultSource(): this;
        noBucket(): this;
        static of<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        noBlock(): this;
        setData<D extends Internal.RegistrateProvider>(type: Internal.ProviderType_<D>, cons: Internal.NonNullBiConsumer_<Internal.DataGenContext<Internal.Fluid, T>, D>): this;
        static lazy<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        block(): com.tterrag.registrate.builders.BlockBuilder<Internal.LiquidBlock, com.tterrag.registrate.builders.FluidBuilder<T, P>>;
        lazy(): Internal.NonNullSupplier<Internal.RegistryEntry<T>>;
        static create<P>(owner: Internal.AbstractRegistrate_<any>, parent: P, name: string, callback: Internal.BuilderCallback_, stillTexture: ResourceLocation_, flowingTexture: ResourceLocation_): com.tterrag.registrate.builders.FluidBuilder<com.tterrag.registrate.fabric.SimpleFlowableFluid$Flowing, P>;
        block<B extends Internal.LiquidBlock>(factory: Internal.NonNullBiFunction_<Internal.NonNullSupplier<T>, Internal.BlockBehaviour$Properties, B>): com.tterrag.registrate.builders.BlockBuilder<B, com.tterrag.registrate.builders.FluidBuilder<T, P>>;
        defaultLang(): this;
        defaultBucket(): this;
        removeTag(...tags: Internal.TagKey_<Internal.Fluid>[]): this;
        get(): Internal.RegistryEntry<T>;
        onRegisterAfter<OR>(dependencyType: Internal.ResourceKey_<Internal.Registry<OR>>, callback: com.tterrag.registrate.util.nullness.NonNullConsumer_<T>): this;
        get entry(): T
    }
    type FluidBuilder_<T extends com.tterrag.registrate.fabric.SimpleFlowableFluid, P> = FluidBuilder<T, P>;
}
declare namespace net.fabricmc.fabric.mixin.event.interaction.client {
    interface KeyBindingAccessor {
        abstract fabric_getTimesPressed(): number;
        (): number;
    }
    type KeyBindingAccessor_ = KeyBindingAccessor;
}
declare namespace com.google.common.base {
    interface Supplier <T> extends Internal.Supplier<T> {
        abstract get(): T;
        (): T;
    }
    type Supplier_<T> = Supplier<T>;
}
declare namespace Internal {
    class MethodInfo$ParamInfo {
        constructor(parameter: any_)
        constructor(parameter: any_, typeMap: Internal.Map_<Internal.Type, Internal.Type>)
        getType(): Internal.ITypeInfo;
        isVararg(): boolean;
        getName(): string;
        setTypeInfo(type: Internal.ITypeInfo_): void;
        get type(): Internal.ITypeInfo
        get vararg(): boolean
        get name(): string
        set typeInfo(type: Internal.ITypeInfo_)
    }
    type MethodInfo$ParamInfo_ = MethodInfo$ParamInfo;
    interface LevelSimulatedRW extends Internal.LevelSimulatedReader, Internal.LevelWriter {
        abstract getHeightmapPos(arg0: Internal.Heightmap$Types_, arg1: BlockPos_): BlockPos;
        setBlock($$0: BlockPos_, $$1: Internal.BlockState_, $$2: number): boolean;
        abstract destroyBlock(arg0: BlockPos_, arg1: boolean, arg2: Internal.Entity_, arg3: number): boolean;
        abstract isFluidAtPosition(arg0: BlockPos_, arg1: Internal.Predicate_<Internal.FluidState>): boolean;
        abstract setBlock(arg0: BlockPos_, arg1: Internal.BlockState_, arg2: number, arg3: number): boolean;
        addFreshEntity($$0: Internal.Entity_): boolean;
        abstract isStateAtPosition(arg0: BlockPos_, arg1: Internal.Predicate_<Internal.BlockState>): boolean;
        abstract removeBlock(arg0: BlockPos_, arg1: boolean): boolean;
        destroyBlock($$0: BlockPos_, $$1: boolean, $$2: Internal.Entity_): boolean;
        abstract getBlockEntity<T extends Internal.BlockEntity>(arg0: BlockPos_, arg1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        destroyBlock($$0: BlockPos_, $$1: boolean): boolean;
    }
    type LevelSimulatedRW_ = LevelSimulatedRW;
    interface GameRulesAccessor {
        callRegister<T extends Internal.GameRules$Value<T>>(name: string, category: Internal.GameRules$Category_, type: Internal.GameRules$Type_<T>): Internal.GameRules$Key<T>;
        getRuleTypes(): Internal.Map<Internal.GameRules$Key<any>, Internal.GameRules$Type<any>>;
        get ruleTypes(): Internal.Map<Internal.GameRules$Key<any>, Internal.GameRules$Type<any>>
    }
    type GameRulesAccessor_ = GameRulesAccessor;
    interface RecipeType <T extends Internal.Recipe<any>> {
        register<T extends Internal.Recipe<any>>($$0: string): this;
        readonly CAMPFIRE_COOKING: Internal.RecipeType$1;
        readonly SMITHING: Internal.RecipeType$1;
        readonly SMOKING: Internal.RecipeType$1;
        readonly BLASTING: Internal.RecipeType$1;
        readonly SMELTING: Internal.RecipeType$1;
        readonly CRAFTING: Internal.RecipeType$1;
        readonly STONECUTTING: Internal.RecipeType$1;
    }
    type RecipeType_<T extends Internal.Recipe<any>> = Special.RecipeType | RecipeType<T>;
    abstract class AbstractContainer extends Internal.AbstractContainerMenu {
        constructor(type: Internal.MenuType_<any>, id: number, inventory: Internal.Inventory_, buffer: Internal.FriendlyByteBuf_)
        constructor(type: Internal.MenuType_<any>, id: number, inventory: Internal.Inventory_)
        static readonly DUMMY: Internal.AbstractContainerMenu;
        readonly player: Internal.Player;
        readonly world: Internal.Level;
    }
    type AbstractContainer_ = AbstractContainer;
    class WeightedPlacedFeature {
        constructor($$0: Internal.Holder_<Internal.PlacedFeature>, $$1: number)
        place($$0: Internal.WorldGenLevel_, $$1: Internal.ChunkGenerator_, $$2: Internal.RandomSource_, $$3: BlockPos_): boolean;
        readonly feature: Internal.Holder<Internal.PlacedFeature>;
        readonly chance: number;
        static readonly CODEC: Internal.Codec<Internal.WeightedPlacedFeature>;
    }
    type WeightedPlacedFeature_ = WeightedPlacedFeature;
    abstract class AbstractMonoBogeyBlock <T extends Internal.MonoBogeyBlockEntity> extends Internal.AbstractBogeyBlock<T> implements Internal.ProperWaterloggedBlock, Internal.IBE<T>, Internal.SpecialBlockItemRequirement {
        constructor(pProperties: Internal.BlockBehaviour$Properties_)
        getConnectorAnchorOffset(): Vec3d;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<T, Internal.InteractionResult>): Internal.InteractionResult;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): T;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<T>): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<T>;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get connectorAnchorOffset(): Vec3d
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly UPSIDE_DOWN: Internal.BooleanProperty;
    }
    type AbstractMonoBogeyBlock_<T extends Internal.MonoBogeyBlockEntity> = AbstractMonoBogeyBlock<T>;
    abstract class RenderStateShard implements Internal.RenderStateShardAccessor, net.irisshaders.batchedentityrendering.mixin.RenderStateShardAccessor, Internal.AccessorRenderStateShard, net.irisshaders.iris.mixin.rendertype.RenderStateShardAccessor {
        constructor($$0: string, $$1: Internal.Runnable_, $$2: Internal.Runnable_)
        static getTranslucentTransparency(): Internal.RenderStateShard$TransparencyStateShard;
        static getGLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        port_lib$setupState(arg0: Internal.Runnable_): void;
        static getNO_TRANSPARENCY$iris_$md$fca01f$1(): Internal.RenderStateShard$TransparencyStateShard;
        static getNO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getGLINT_TRANSPARENCY$iris_$md$fca01f$2(): Internal.RenderStateShard$TransparencyStateShard;
        clearRenderState(): void;
        static getCRUMBLING_TRANSPARENCY$iris_$md$fca01f$3(): Internal.RenderStateShard$TransparencyStateShard;
        setupRenderState(): void;
        hex$name(): string;
        getName(): string;
        port_lib$clearState(arg0: Internal.Runnable_): void;
        static getCRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getTranslucentTransparency$iris_$md$fca01f$0(): Internal.RenderStateShard$TransparencyStateShard;
        get translucentTransparency(): Internal.RenderStateShard$TransparencyStateShard
        get GLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get NO_TRANSPARENCY$iris_$md$fca01f$1(): Internal.RenderStateShard$TransparencyStateShard
        get NO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get GLINT_TRANSPARENCY$iris_$md$fca01f$2(): Internal.RenderStateShard$TransparencyStateShard
        get CRUMBLING_TRANSPARENCY$iris_$md$fca01f$3(): Internal.RenderStateShard$TransparencyStateShard
        get name(): string
        get CRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get translucentTransparency$iris_$md$fca01f$0(): Internal.RenderStateShard$TransparencyStateShard
        static readonly RENDERTYPE_ENTITY_NO_OUTLINE_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly ITEM_ENTITY_TARGET: Internal.RenderStateShard$OutputStateShard;
        static readonly RENDERTYPE_TRANSLUCENT_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly VIEW_OFFSET_Z_LAYERING: Internal.RenderStateShard$LayeringStateShard;
        static readonly RENDERTYPE_TEXT_BACKGROUND_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly CULL: Internal.RenderStateShard$CullStateShard;
        static readonly POSITION_COLOR_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_ENERGY_SWIRL_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_SOLID_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly COLOR_DEPTH_WRITE: Internal.RenderStateShard$WriteMaskStateShard;
        static readonly RENDERTYPE_ENTITY_SMOOTH_CUTOUT_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly POSITION_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly VIEW_SCALE_Z_EPSILON: 0.99975586;
        static readonly RENDERTYPE_ITEM_ENTITY_TRANSLUCENT_CULL_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly GLINT_TRANSPARENCY: Internal.RenderStateShard$TransparencyStateShard;
        static readonly NO_TRANSPARENCY: Internal.RenderStateShard$TransparencyStateShard;
        static readonly RENDERTYPE_GLINT_TRANSLUCENT_SHADER: Internal.RenderStateShard$ShaderStateShard;
        setupState: Internal.Runnable;
        static readonly RENDERTYPE_TEXT_SEE_THROUGH_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_CUTOUT_MIPPED_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_ENTITY_SHADOW_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_TRANSLUCENT_MOVING_BLOCK_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly DEPTH_WRITE: Internal.RenderStateShard$WriteMaskStateShard;
        static readonly RENDERTYPE_TRIPWIRE_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly TRANSLUCENT_TRANSPARENCY: Internal.RenderStateShard$TransparencyStateShard;
        static readonly RENDERTYPE_TEXT_INTENSITY_SEE_THROUGH_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly DEFAULT_LINE: Internal.RenderStateShard$LineStateShard;
        static readonly NO_TEXTURE: Internal.RenderStateShard$EmptyTextureStateShard;
        static readonly RENDERTYPE_ENTITY_CUTOUT_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly LEQUAL_DEPTH_TEST: Internal.RenderStateShard$DepthTestStateShard;
        static readonly RENDERTYPE_GUI_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_CRUMBLING_SHADER: Internal.RenderStateShard$ShaderStateShard;
        readonly name: string;
        static readonly NO_OVERLAY: Internal.RenderStateShard$OverlayStateShard;
        static readonly LIGHTNING_TRANSPARENCY: Internal.RenderStateShard$TransparencyStateShard;
        static readonly RENDERTYPE_LEASH_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_TEXT_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_TEXT_INTENSITY_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_TEXT_BACKGROUND_SEE_THROUGH_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_ARMOR_GLINT_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_TRANSLUCENT_NO_CRUMBLING_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_ARMOR_ENTITY_GLINT_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_ENTITY_TRANSLUCENT_CULL_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly GREATER_DEPTH_TEST: Internal.RenderStateShard$DepthTestStateShard;
        static readonly ENTITY_GLINT_TEXTURING: Internal.RenderStateShard$TexturingStateShard;
        static readonly GLINT_TEXTURING: Internal.RenderStateShard$TexturingStateShard;
        static readonly RENDERTYPE_EYES_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_CUTOUT_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_END_GATEWAY_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_ENTITY_GLINT_DIRECT_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_END_PORTAL_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly OUTLINE_TARGET: Internal.RenderStateShard$OutputStateShard;
        static readonly RENDERTYPE_GUI_GHOST_RECIPE_OVERLAY_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_GUI_OVERLAY_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_GUI_TEXT_HIGHLIGHT_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly LIGHTMAP: Internal.RenderStateShard$LightmapStateShard;
        static readonly CLOUDS_TARGET: Internal.RenderStateShard$OutputStateShard;
        static readonly POLYGON_OFFSET_LAYERING: Internal.RenderStateShard$LayeringStateShard;
        static readonly RENDERTYPE_ENTITY_CUTOUT_NO_CULL_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_GLINT_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_LINES_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_LIGHTNING_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly EQUAL_DEPTH_TEST: Internal.RenderStateShard$DepthTestStateShard;
        static readonly NO_LIGHTMAP: Internal.RenderStateShard$LightmapStateShard;
        static readonly TRANSLUCENT_TARGET: Internal.RenderStateShard$OutputStateShard;
        static readonly POSITION_COLOR_TEX_LIGHTMAP_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly CRUMBLING_TRANSPARENCY: Internal.RenderStateShard$TransparencyStateShard;
        static readonly BLOCK_SHEET_MIPPED: Internal.RenderStateShard$TextureStateShard;
        static readonly RENDERTYPE_ENTITY_TRANSLUCENT_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly POSITION_COLOR_LIGHTMAP_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_ENTITY_CUTOUT_NO_CULL_Z_OFFSET_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly NO_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_ENTITY_DECAL_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly PARTICLES_TARGET: Internal.RenderStateShard$OutputStateShard;
        static readonly NO_DEPTH_TEST: Internal.RenderStateShard$DepthTestStateShard;
        static readonly POSITION_COLOR_TEX_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly DEFAULT_TEXTURING: Internal.RenderStateShard$TexturingStateShard;
        static readonly BLOCK_SHEET: Internal.RenderStateShard$TextureStateShard;
        static readonly COLOR_WRITE: Internal.RenderStateShard$WriteMaskStateShard;
        static readonly MAIN_TARGET: Internal.RenderStateShard$OutputStateShard;
        static readonly NO_LAYERING: Internal.RenderStateShard$LayeringStateShard;
        static readonly OR_REVERSE_COLOR_LOGIC: Internal.RenderStateShard$ColorLogicStateShard;
        static readonly RENDERTYPE_ARMOR_CUTOUT_NO_CULL_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_OUTLINE_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_GLINT_DIRECT_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_ENTITY_GLINT_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_WATER_MASK_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly MAX_ENCHANTMENT_GLINT_SPEED_MILLIS: 8.0;
        static readonly NO_CULL: Internal.RenderStateShard$CullStateShard;
        static readonly RENDERTYPE_ENTITY_ALPHA_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_ENTITY_TRANSLUCENT_EMISSIVE_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly RENDERTYPE_ENTITY_SOLID_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly NO_COLOR_LOGIC: Internal.RenderStateShard$ColorLogicStateShard;
        static readonly OVERLAY: Internal.RenderStateShard$OverlayStateShard;
        static readonly POSITION_TEX_SHADER: Internal.RenderStateShard$ShaderStateShard;
        static readonly ADDITIVE_TRANSPARENCY: Internal.RenderStateShard$TransparencyStateShard;
        static readonly WEATHER_TARGET: Internal.RenderStateShard$OutputStateShard;
        static readonly RENDERTYPE_BEACON_BEAM_SHADER: Internal.RenderStateShard$ShaderStateShard;
    }
    type RenderStateShard_ = RenderStateShard;
    class PackagingRequest extends Internal.Record {
        constructor(item: Internal.ItemStack_, count: Internal.MutableInt_, address: string, linkIndex: number, finalLink: Internal.MutableBoolean_, packageCounter: Internal.MutableInt_, orderId: number, context: Internal.PackageOrderWithCrafts_)
        getCount(): number;
        finalLink(): Internal.MutableBoolean;
        packageCounter(): Internal.MutableInt;
        address(): string;
        item(): Internal.ItemStack;
        isEmpty(): boolean;
        linkIndex(): number;
        count(): Internal.MutableInt;
        orderId(): number;
        static fromNBT(tag: Internal.CompoundTag_): Internal.PackagingRequest;
        toNBT(): Internal.CompoundTag;
        subtract(toSubtract: number): void;
        static create(item: Internal.ItemStack_, count: number, address: string, linkIndex: number, finalLink: Internal.MutableBoolean_, packageCount: number, orderId: number, context: Internal.PackageOrderWithCrafts_): Internal.PackagingRequest;
        context(): Internal.PackageOrderWithCrafts;
        get count(): number
        get empty(): boolean
    }
    type PackagingRequest_ = PackagingRequest;
    class ItemAmethystPigment extends Internal.Item implements Internal.PigmentItem {
        constructor(pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        provideColor(stack: Internal.ItemStack_, owner: Internal.UUID_): Internal.ColorProvider;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemAmethystPigment_ = ItemAmethystPigment;
    interface ProcessingRecipeBuilder$ProcessingRecipeFactory <T extends Internal.ProcessingRecipe<any>> {
        abstract create(arg0: Internal.ProcessingRecipeBuilder$ProcessingRecipeParams_): T;
        (arg0: Internal.ProcessingRecipeBuilder$ProcessingRecipeParams): T;
    }
    type ProcessingRecipeBuilder$ProcessingRecipeFactory_<T extends Internal.ProcessingRecipe<any>> = ProcessingRecipeBuilder$ProcessingRecipeFactory<T>;
    class BarrelBlock extends Internal.BaseEntityBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly OPEN: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type BarrelBlock_ = BarrelBlock;
    class BoilerBlock$Style extends Internal.Enum<Internal.BoilerBlock$Style> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static values(): Internal.BoilerBlock$Style[];
        getSerializedName(): string;
        static valueOf(name: string): Internal.BoilerBlock$Style;
        getTexture(): string;
        get serializedName(): string
        get texture(): string
        static readonly SMOKEBOX: Internal.BoilerBlock$Style;
        static readonly GULLET: Internal.BoilerBlock$Style;
    }
    type BoilerBlock$Style_ = "smokebox" | "gullet" | BoilerBlock$Style;
    class ClientboundSectionBlocksUpdatePacket implements Internal.IMixinChunkDeltaUpdateS2CPacket, Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.SectionPos_, $$1: any_, $$2: Internal.LevelChunkSection_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        litematica_getSection(): Internal.SectionPos;
        runUpdates($$0: Internal.BiConsumer_<BlockPos, Internal.BlockState>): void;
        isSkippable(): boolean;
        get skippable(): boolean
        readonly positions: number[];
        readonly sectionPos: Internal.SectionPos;
    }
    type ClientboundSectionBlocksUpdatePacket_ = ClientboundSectionBlocksUpdatePacket;
    class FilterItemStack {
        test(world: Internal.Level_, stack: Internal.FluidStack_): boolean;
        test(world: Internal.Level_, stack: Internal.FluidStack_, matchNBT: boolean): boolean;
        fluid(level: Internal.Level_): Internal.FluidStack;
        isFilterItem(): boolean;
        static of(tag: Internal.CompoundTag_): Internal.FilterItemStack;
        test(world: Internal.Level_, stack: Internal.ItemStack_, matchNBT: boolean): boolean;
        item(): Internal.ItemStack;
        isEmpty(): boolean;
        static of(filter: Internal.ItemStack_): Internal.FilterItemStack;
        test(world: Internal.Level_, stack: Internal.ItemStack_): boolean;
        static empty(): Internal.FilterItemStack;
        serializeNBT(): Internal.CompoundTag;
        get filterItem(): boolean
        get empty(): boolean
    }
    type FilterItemStack_ = FilterItemStack;
    class ThrownPotion extends Internal.ThrowableItemProjectile implements Internal.PotionItemEntityExtensions, Internal.ItemSupplier {
        constructor($$0: Internal.EntityType_<Internal.ThrownPotion>, $$1: Internal.Level_)
        constructor($$0: Internal.Level_, $$1: Internal.LivingEntity_)
        constructor($$0: Internal.Level_, $$1: number, $$2: number, $$3: number)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        handler$ffj000$moonlight$extinguishILightables(pos: BlockPos_, ci: Internal.CallbackInfo_, state: Internal.BlockState_): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        setMilk(value: boolean): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        handler$zjb002$ad_astra$adastra$getGravity(cir: Internal.CallbackInfoReturnable_<any>): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        isMilk(): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set milk(value: boolean)
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        get milk(): boolean
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
        static readonly SPLASH_RANGE: 4.0;
        static readonly WATER_SENSITIVE_OR_ON_FIRE: Internal.Predicate<Internal.LivingEntity>;
    }
    type ThrownPotion_ = ThrownPotion;
    class KeyCaps {
        constructor()
        getZoneColor(zone: Internal.KeyZone_): number;
        static blendColors(color1: number, color2: number): number;
        static fromNBT(nbt: Internal.CompoundTag_): Internal.KeyCaps;
        removeColor(craftingIndex: number): void;
        changeColor(newColor: number, craftingIndex: number): void;
        isDefault(): boolean;
        getZoneColor(tintIndex: number): number;
        blendAndSetColor(newColor: number, craftingIndex: number): void;
        isDefault(cZone: number): boolean;
        isDefault(cZone: Internal.KeyCraftingZone_): boolean;
        toSubNBT(): Internal.CompoundTag;
        static isZoneType(tintIndex: number, zoneType: Internal.KeyZone_[]): boolean;
        static changeColor(itemStack: Internal.ItemStack_, color: number, craftingIndex: number): Internal.ItemStack;
        static fromItemStack(itemStack: Internal.ItemStack_): Internal.KeyCaps;
        getDisplayText(keyZone: Internal.KeyZone_): net.minecraft.network.chat.Component;
        logSelf(): void;
        get "default"(): boolean
        craftingNulls: number;
        static readonly DEFAULT_COLOR: 1908001;
        static readonly KEY_CAP_KEY: "key_caps";
        static readonly CRAFTING_NULLS_KEY: "crafting_nulls";
        static readonly CRAFTING_VALUES_KEY: "crafting_values";
        craftingValues: number[];
    }
    type KeyCaps_ = KeyCaps;
    interface FormattedCharSink {
        abstract accept(arg0: number, arg1: Internal.Style_, arg2: number): boolean;
        (arg0: number, arg1: Internal.Style, arg2: number): boolean;
    }
    type FormattedCharSink_ = FormattedCharSink;
    interface IMixinWorldTickScheduler <T> {
        abstract litematica_getChunkTickSchedulers(): Internal.Long2ObjectMap<Internal.LevelChunkTicks<T>>;
        (): Internal.Long2ObjectMap_<Internal.LevelChunkTicks<T>>;
    }
    type IMixinWorldTickScheduler_<T> = IMixinWorldTickScheduler<T>;
    abstract class Metric {
        name(): string;
        unit(): string;
        id(): number;
        static formatDefault(value: number): string;
        static formatBytes(bytes: number): string;
        format(value: number): string;
        static metrics(): Internal.Map<string, Internal.Metric>;
        static formatTime(value: number): string;
    }
    type Metric_ = Metric;
    class SyncedProperty <T> extends Internal.Observable<T> {
        constructor(index: number, klass: T, initial: T)
        read(buf: Internal.FriendlyByteBuf_): void;
        write(buf: Internal.FriendlyByteBuf_): void;
        markDirty(): void;
        needsSync(): boolean;
        index(): number;
    }
    type SyncedProperty_<T> = SyncedProperty<T>;
    interface DisconnectPacketSource {
        abstract createDisconnectPacket(arg0: net.minecraft.network.chat.Component_): Internal.Packet<any>;
        (arg0: net.minecraft.network.chat.Component): Internal.Packet_<any>;
    }
    type DisconnectPacketSource_ = DisconnectPacketSource;
    class StructureRenderer implements Internal.DebugRenderer$SimpleDebugRenderer {
        constructor($$0: Internal.Minecraft_)
        render($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource_, $$2: number, $$3: number, $$4: number): void;
        addBoundingBox($$0: Internal.BoundingBox_, $$1: Internal.List_<Internal.BoundingBox>, $$2: Internal.List_<boolean>, $$3: Internal.DimensionType_): void;
        clear(): void;
    }
    type StructureRenderer_ = StructureRenderer;
    class FallingBlockBuilder extends Internal.BlockBuilder {
        constructor(i: ResourceLocation_)
        /**
         * Tags both the block and the item with the given tag.
        */
        tag(arg0: ResourceLocation_): Internal.BuilderBase<any>;
        createObject(): any;
        dustColor(color: dev.latvian.mods.rhino.mod.util.color.Color_): this;
    }
    type FallingBlockBuilder_ = FallingBlockBuilder;
    class GameType extends Internal.Enum<Internal.GameType> implements Internal.StringRepresentable {
        static getNullableId($$0: Internal.GameType_): number;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        isSurvival(): boolean;
        static byName($$0: string): Internal.GameType;
        static values(): Internal.GameType[];
        static valueOf($$0: string): Internal.GameType;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static byName($$0: string, $$1: Internal.GameType_): Internal.GameType;
        getShortDisplayName(): net.minecraft.network.chat.Component;
        isCreative(): boolean;
        isBlockPlacingRestricted(): boolean;
        getName(): string;
        static byId($$0: number): Internal.GameType;
        static byNullableId($$0: number): Internal.GameType;
        updatePlayerAbilities($$0: Internal.Abilities_): void;
        getLongDisplayName(): net.minecraft.network.chat.Component;
        getId(): number;
        get serializedName(): string
        get survival(): boolean
        get shortDisplayName(): net.minecraft.network.chat.Component
        get creative(): boolean
        get blockPlacingRestricted(): boolean
        get name(): string
        get longDisplayName(): net.minecraft.network.chat.Component
        get id(): number
        static readonly CODEC: Internal.StringRepresentable$EnumCodec<Internal.GameType>;
        static readonly DEFAULT_MODE: Internal.GameType;
        static readonly ADVENTURE: Internal.GameType;
        static readonly SPECTATOR: Internal.GameType;
        static readonly CREATIVE: Internal.GameType;
        static readonly SURVIVAL: Internal.GameType;
    }
    type GameType_ = "spectator" | "adventure" | GameType | "survival" | "creative";
    abstract class LootPoolEntryContainer$Builder <T extends Internal.LootPoolEntryContainer$Builder<T>> implements Internal.ConditionUserBuilder<T> {
        constructor()
        abstract build(): Internal.LootPoolEntryContainer;
        when<E>($$0: Internal.Iterable_<E>, $$1: Internal.Function_<E, Internal.LootItemCondition$Builder>): T;
        otherwise($$0: Internal.LootPoolEntryContainer$Builder_<any>): Internal.AlternativesEntry$Builder;
        when(arg0: Internal.LootItemCondition$Builder_): Internal.ConditionUserBuilder<any>;
        when($$0: Internal.LootItemCondition$Builder_): T;
        then($$0: Internal.LootPoolEntryContainer$Builder_<any>): Internal.SequentialEntry$Builder;
        append($$0: Internal.LootPoolEntryContainer$Builder_<any>): Internal.EntryGroup$Builder;
        unwrap(): T;
        unwrap(): Internal.ConditionUserBuilder<any>;
    }
    type LootPoolEntryContainer$Builder_<T extends Internal.LootPoolEntryContainer$Builder<T>> = LootPoolEntryContainer$Builder<T>;
    interface CloseableResourceManager extends Internal.ResourceManager, Internal.AutoCloseable {
        open($$0: ResourceLocation_): Internal.InputStream;
        fromMap($$0: Internal.Map_<ResourceLocation, Internal.Resource>): Internal.ResourceProvider;
        abstract getResourceStack(arg0: ResourceLocation_): Internal.List<Internal.Resource>;
        openAsReader($$0: ResourceLocation_): Internal.BufferedReader;
        abstract close(): void;
        abstract getNamespaces(): Internal.Set<string>;
        abstract listResources(arg0: string, arg1: Internal.Predicate_<ResourceLocation>): Internal.Map<ResourceLocation, Internal.Resource>;
        abstract getResource(arg0: ResourceLocation_): Internal.Optional<Internal.Resource>;
        abstract listResourceStacks(arg0: string, arg1: Internal.Predicate_<ResourceLocation>): Internal.Map<ResourceLocation, Internal.List<Internal.Resource>>;
        abstract listPacks(): Internal.Stream<Internal.PackResources>;
        getResourceOrThrow($$0: ResourceLocation_): Internal.Resource;
        get namespaces(): Internal.Set<string>
    }
    type CloseableResourceManager_ = CloseableResourceManager;
    interface HumanoidModelAccessor {
        abstract port_lib$poseRightArm(arg0: Internal.LivingEntity_): void;
        abstract port_lib$poseLeftArm(arg0: Internal.LivingEntity_): void;
    }
    type HumanoidModelAccessor_ = HumanoidModelAccessor;
    interface LivingEntityEvents$Fall {
        abstract onFall(arg0: Internal.LivingEntityEvents$Fall$FallEvent_): void;
        (arg0: Internal.LivingEntityEvents$Fall$FallEvent): void;
    }
    type LivingEntityEvents$Fall_ = LivingEntityEvents$Fall;
    class EntropyManipulatorItem extends Internal.AEBasePoweredItem implements Internal.IBlockTool {
        constructor(props: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly ENERGY_PER_USE: 1600;
    }
    type EntropyManipulatorItem_ = EntropyManipulatorItem;
    class GoalSelector {
        constructor($$0: Internal.Supplier_<Internal.ProfilerFiller>)
        addGoal($$0: number, $$1: Internal.Goal_): void;
        removeGoal($$0: Internal.Goal_): void;
        getRunningGoals(): Internal.Stream<Internal.WrappedGoal>;
        setControlFlag($$0: Internal.Goal$Flag_, $$1: boolean): void;
        disableControlFlag($$0: Internal.Goal$Flag_): void;
        tickRunningGoals($$0: boolean): void;
        enableControlFlag($$0: Internal.Goal$Flag_): void;
        setNewGoalRate($$0: number): void;
        tick(): void;
        removeAllGoals($$0: Internal.Predicate_<Internal.Goal>): void;
        getAvailableGoals(): Internal.Set<Internal.WrappedGoal>;
        get runningGoals(): Internal.Stream<Internal.WrappedGoal>
        set newGoalRate($$0: number)
        get availableGoals(): Internal.Set<Internal.WrappedGoal>
    }
    type GoalSelector_ = GoalSelector;
    class SodiumWorldRenderer implements Internal.SodiumWorldRendererAccessor {
        constructor(client: Internal.Minecraft_)
        static instanceNullable(): Internal.SodiumWorldRenderer;
        reload(): void;
        isEntityVisible(entity: Internal.Entity_): boolean;
        isSectionReady(x: number, y: number, z: number): boolean;
        isTerrainRenderComplete(): boolean;
        invokeRenderBlockEntities(arg0: Internal.PoseStack_, arg1: Internal.RenderBuffers_, arg2: Internal.Long2ObjectMap_<any>, arg3: number, arg4: Internal.MultiBufferSource$BufferSource_, arg5: number, arg6: number, arg7: number, arg8: Internal.BlockEntityRenderDispatcher_): void;
        getVisibleChunkCount(): number;
        drawChunkLayer(renderLayer: Internal.RenderType_, matrices: Internal.ChunkRenderMatrices_, x: number, y: number, z: number): void;
        setWorld(world: Internal.ClientLevel_): void;
        static instance(): Internal.SodiumWorldRenderer;
        scheduleRebuildForChunk(x: number, y: number, z: number, important: boolean): void;
        scheduleTerrainUpdate(): void;
        setupTerrain(camera: Internal.Camera_, viewport: Internal.Viewport_, frame: number, spectator: boolean, updateChunksImmediately: boolean): void;
        getChunksDebugString(): string;
        scheduleRebuildForChunks(minX: number, minY: number, minZ: number, maxX: number, maxY: number, maxZ: number, important: boolean): void;
        renderBlockEntities(matrices: Internal.PoseStack_, bufferBuilders: Internal.RenderBuffers_, blockBreakingProgressions: Internal.Long2ObjectMap_<Internal.SortedSet<Internal.BlockDestructionProgress>>, camera: Internal.Camera_, tickDelta: number): void;
        getDebugStrings(): Internal.Collection<string>;
        isBoxVisible(x1: number, y1: number, z1: number, x2: number, y2: number, z2: number): boolean;
        scheduleRebuildForBlockArea(minX: number, minY: number, minZ: number, maxX: number, maxY: number, maxZ: number, important: boolean): void;
        invokeRenderGlobalBlockEntities(arg0: Internal.PoseStack_, arg1: Internal.RenderBuffers_, arg2: Internal.Long2ObjectMap_<any>, arg3: number, arg4: Internal.MultiBufferSource$BufferSource_, arg5: number, arg6: number, arg7: number, arg8: Internal.BlockEntityRenderDispatcher_): void;
        get terrainRenderComplete(): boolean
        get visibleChunkCount(): number
        set world(world: Internal.ClientLevel_)
        get chunksDebugString(): string
        get debugStrings(): Internal.Collection<string>
    }
    type SodiumWorldRenderer_ = SodiumWorldRenderer;
    class PressingRecipe extends Internal.ProcessingRecipe<net.minecraft.world.Container> implements Internal.IAssemblyRecipe {
        constructor(params: Internal.ProcessingRecipeBuilder$ProcessingRecipeParams_)
        getDescriptionForAssembly(): net.minecraft.network.chat.Component;
        supportsAssembly(): boolean;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getSchema(): Internal.RecipeSchema;
        addAssemblyFluidIngredients(list: Internal.List_<Internal.FluidIngredient>): void;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        getJEISubCategory(): Internal.SequencedAssemblySubCategoryType;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        addRequiredMachines(list: Internal.Set_<Internal.ItemLike>): void;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        addAssemblyIngredients(list: Internal.List_<Internal.Ingredient>): void;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        getRemainingItems($$0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        get descriptionForAssembly(): net.minecraft.network.chat.Component
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        get JEISubCategory(): Internal.SequencedAssemblySubCategoryType
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type PressingRecipe_ = PressingRecipe;
    class CassetteItem extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CassetteItem_ = CassetteItem;
    class ResourceOrTagArgument <T> implements Internal.ArgumentType<Internal.ResourceOrTagArgument$Result<T>> {
        constructor($$0: Internal.CommandBuildContext_, $$1: Internal.ResourceKey_<Internal.Registry<T>>)
        parse($$0: Internal.StringReader_): Internal.ResourceOrTagArgument$Result<T>;
        getExamples(): Internal.Collection<string>;
        static getResourceOrTag<T>($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string, $$2: Internal.ResourceKey_<Internal.Registry<T>>): Internal.ResourceOrTagArgument$Result<T>;
        static resourceOrTag<T>($$0: Internal.CommandBuildContext_, $$1: Internal.ResourceKey_<Internal.Registry<T>>): Internal.ResourceOrTagArgument<T>;
        listSuggestions<S>($$0: Internal.CommandContext_<S>, $$1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        parse(arg0: Internal.StringReader_): any;
        get examples(): Internal.Collection<string>
    }
    type ResourceOrTagArgument_<T> = ResourceOrTagArgument<T>;
    class ClientboundBlockUpdatePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        constructor($$0: Internal.BlockGetter_, $$1: BlockPos_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        getPos(): BlockPos;
        write($$0: Internal.FriendlyByteBuf_): void;
        getBlockState(): Internal.BlockState;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get pos(): BlockPos
        get blockState(): Internal.BlockState
        get skippable(): boolean
    }
    type ClientboundBlockUpdatePacket_ = ClientboundBlockUpdatePacket;
    class BlockEntityRelay$RelayNetwork {
        constructor(root: Internal.BlockEntityRelay_, relays: Internal.Set_<Internal.BlockEntityRelay>, nonRelays: Internal.Set_<Internal.ILinkable>, mediaExchangers: Internal.Set_<Internal.ILinkable>)
        getComputedAverageMedia(): number;
        copy(root: Internal.BlockEntityRelay_, relays: Internal.Set_<Internal.BlockEntityRelay>, nonRelays: Internal.Set_<Internal.ILinkable>, mediaExchangers: Internal.Set_<Internal.ILinkable>): this;
        getLastTickComputedAverageMedia(): number;
        setPigment(pigment: Internal.FrozenPigment_, time: number): void;
        canAcceptMedia(other: Internal.ILinkable_, otherMediaLevel: number): number;
        getTimeColouriserSet(): number;
        static copy$default(arg0: Internal.BlockEntityRelay$RelayNetwork_, arg1: Internal.BlockEntityRelay_, arg2: Internal.Set_<any>, arg3: Internal.Set_<any>, arg4: Internal.Set_<any>, arg5: number, arg6: any): Internal.BlockEntityRelay$RelayNetwork;
        getLinkablesAcceptedFromThisTick(): Internal.Set<Internal.ILinkable>;
        getMediaExchangers(): Internal.Set<Internal.ILinkable>;
        getPigment(): Internal.FrozenPigment;
        setNumNonRelays(<set-?>: number): void;
        setPigment(<set-?>: Internal.FrozenPigment_): void;
        getRoot(): Internal.BlockEntityRelay;
        getLastTickAcceptedMedia(): number;
        getNonRelays(): Internal.Set<Internal.ILinkable>;
        getNumMediaExchangers(): number;
        setNumMediaExchangers(<set-?>: number): void;
        getNumNonRelays(): number;
        component1(): Internal.BlockEntityRelay;
        setLastTickAcceptedMedia(<set-?>: number): void;
        component3(): Internal.Set<Internal.ILinkable>;
        component4(): Internal.Set<Internal.ILinkable>;
        tick(): void;
        acceptMedia(other: Internal.ILinkable_, sentMedia: number): void;
        getRelays(): Internal.Set<Internal.BlockEntityRelay>;
        setTimeColouriserSet(<set-?>: number): void;
        setComputedAverageMedia(<set-?>: number): void;
        setLastTickComputedAverageMedia(<set-?>: number): void;
        absorb(other: Internal.BlockEntityRelay$RelayNetwork_): void;
        component2(): Internal.Set<Internal.BlockEntityRelay>;
        get computedAverageMedia(): number
        get lastTickComputedAverageMedia(): number
        get timeColouriserSet(): number
        get linkablesAcceptedFromThisTick(): Internal.Set<Internal.ILinkable>
        get mediaExchangers(): Internal.Set<Internal.ILinkable>
        get pigment(): Internal.FrozenPigment
        set numNonRelays(<set-?>: number)
        set pigment(<set-?>: Internal.FrozenPigment_)
        get root(): Internal.BlockEntityRelay
        get lastTickAcceptedMedia(): number
        get nonRelays(): Internal.Set<Internal.ILinkable>
        get numMediaExchangers(): number
        set numMediaExchangers(<set-?>: number)
        get numNonRelays(): number
        set lastTickAcceptedMedia(<set-?>: number)
        get relays(): Internal.Set<Internal.BlockEntityRelay>
        set timeColouriserSet(<set-?>: number)
        set computedAverageMedia(<set-?>: number)
        set lastTickComputedAverageMedia(<set-?>: number)
    }
    type BlockEntityRelay$RelayNetwork_ = BlockEntityRelay$RelayNetwork;
    class Mirror extends Internal.Enum<Internal.Mirror> implements Internal.StringRepresentable {
        getRotation($$0: Internal.Direction_): Internal.Rotation;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static values(): Internal.Mirror[];
        getSerializedName(): string;
        mirror($$0: Internal.Direction_): Internal.Direction;
        mirror($$0: number, $$1: number): number;
        rotation(): Internal.OctahedralGroup;
        static valueOf($$0: string): Internal.Mirror;
        symbol(): net.minecraft.network.chat.Component;
        get serializedName(): string
        static readonly CODEC: Internal.Codec<Internal.Mirror>;
        static readonly FRONT_BACK: Internal.Mirror;
        static readonly NONE: Internal.Mirror;
        static readonly LEFT_RIGHT: Internal.Mirror;
    }
    type Mirror_ = "left_right" | "front_back" | Mirror | "none";
    class GrandSpellHandler implements Internal.SpecialHandler {
        constructor(action: Internal.Action_)
        getName(): net.minecraft.network.chat.Component;
        act(): Internal.Action;
        get name(): net.minecraft.network.chat.Component
    }
    type GrandSpellHandler_ = GrandSpellHandler;
    class Container extends Internal.Component {
        constructor()
        findComponentAt(arg0: number, arg1: number): Internal.Component;
        isValidateRoot(): boolean;
        getComponent(arg0: number): Internal.Component;
        setFocusTraversalPolicyProvider(arg0: boolean): void;
        getListeners<T extends Internal.EventListener>(arg0: T): T[];
        getMousePosition(arg0: boolean): Internal.Point;
        add(arg0: Internal.Component_): Internal.Component;
        remove(arg0: number): void;
        isFocusTraversalPolicySet(): boolean;
        add(arg0: Internal.Component_, arg1: any): void;
        getComponents(): Internal.Component[];
        findComponentAt(arg0: Internal.Point_): Internal.Component;
        add(arg0: Internal.Component_, arg1: any, arg2: number): void;
        setComponentZOrder(arg0: Internal.Component_, arg1: number): void;
        add(arg0: string, arg1: Internal.Component_): Internal.Component;
        transferFocusDownCycle(): void;
        removeAll(): void;
        /**
         * @deprecated
        */
        countComponents(): number;
        getFocusTraversalPolicy(): Internal.FocusTraversalPolicy;
        add(arg0: Internal.Component_, arg1: number): Internal.Component;
        getContainerListeners(): Internal.ContainerListener[];
        isFocusCycleRoot(): boolean;
        isFocusTraversalPolicyProvider(): boolean;
        getInsets(): Internal.Insets;
        removeContainerListener(arg0: Internal.ContainerListener_): void;
        getComponentZOrder(arg0: Internal.Component_): number;
        setFocusCycleRoot(arg0: boolean): void;
        printComponents(arg0: Internal.Graphics_): void;
        paintComponents(arg0: Internal.Graphics_): void;
        setFocusTraversalPolicy(arg0: Internal.FocusTraversalPolicy_): void;
        getComponentCount(): number;
        /**
         * @deprecated
        */
        insets(): Internal.Insets;
        getLayout(): Internal.LayoutManager;
        setLayout(arg0: Internal.LayoutManager_): void;
        isAncestorOf(arg0: Internal.Component_): boolean;
        addContainerListener(arg0: Internal.ContainerListener_): void;
        remove(arg0: Internal.Component_): void;
        get validateRoot(): boolean
        set focusTraversalPolicyProvider(arg0: boolean)
        get focusTraversalPolicySet(): boolean
        get components(): Internal.Component[]
        get focusTraversalPolicy(): Internal.FocusTraversalPolicy
        get containerListeners(): Internal.ContainerListener[]
        get focusCycleRoot(): boolean
        get focusTraversalPolicyProvider(): boolean
        get insets(): Internal.Insets
        set focusCycleRoot(arg0: boolean)
        set focusTraversalPolicy(arg0: Internal.FocusTraversalPolicy_)
        get componentCount(): number
        get layout(): Internal.LayoutManager
        set layout(arg0: Internal.LayoutManager_)
    }
    type Container_ = Container;
    class HugeCloverFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        checkSpace(world: Internal.WorldGenLevel_, pos: BlockPos_): boolean;
        setBlock(world: Internal.WorldGenLevel_, pos: BlockPos_, state: Internal.BlockState_): boolean;
    }
    type HugeCloverFeature_ = HugeCloverFeature;
    abstract class StructBuffer <T extends Internal.Struct, SELF extends Internal.StructBuffer<T, SELF>> extends Internal.CustomBuffer<SELF> implements Internal.Iterable<T> {
        put(arg0: T): SELF;
        get(arg0: number, arg1: T): SELF;
        stream(): Internal.Stream<T>;
        spliterator(): Internal.Spliterator<T>;
        apply(arg0: Internal.Consumer_<T>): SELF;
        apply(arg0: number, arg1: Internal.Consumer_<T>): SELF;
        get(arg0: T): SELF;
        iterator(): Internal.Iterator<T>;
        get(arg0: number): T;
        forEach(arg0: Internal.Consumer_<T>): void;
        put(arg0: number, arg1: T): SELF;
        parallelStream(): Internal.Stream<T>;
        get(): T;
    }
    type StructBuffer_<T extends Internal.Struct, SELF extends Internal.StructBuffer<T, SELF>> = StructBuffer<T, SELF>;
    class StrongholdLocationCache extends Internal.SavedData {
        constructor()
        static getFileId(dimensionType: Internal.Holder_<Internal.DimensionType>): string;
        getChunkPosList(): Internal.List<Internal.ChunkPos>;
        static load(arg: Internal.CompoundTag_): Internal.StrongholdLocationCache;
        setChunkPosList(positions: Internal.List_<Internal.ChunkPos>): void;
        get chunkPosList(): Internal.List<Internal.ChunkPos>
        set chunkPosList(positions: Internal.List_<Internal.ChunkPos>)
    }
    type StrongholdLocationCache_ = StrongholdLocationCache;
    class LightningBolt extends Internal.Entity {
        constructor($$0: Internal.EntityType_<Internal.LightningBolt>, $$1: Internal.Level_)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setCause($$0: Internal.ServerPlayer_): void;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        handler$zmn000$architectury$handleLightning(ci: Internal.CallbackInfo_, list: Internal.List_<any>): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        setVisualOnly($$0: boolean): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getCause(): Internal.ServerPlayer;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        getBlocksSetOnFire(): number;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getHitEntities(): Internal.Stream<Internal.Entity>;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        set cause($$0: Internal.ServerPlayer_)
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        set visualOnly($$0: boolean)
        get cause(): Internal.ServerPlayer
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get blocksSetOnFire(): number
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get hitEntities(): Internal.Stream<Internal.Entity>
        get profile(): Internal.GameProfile
        seed: number;
    }
    type LightningBolt_ = LightningBolt;
    class TextStyle extends Internal.Enum<Internal.TextStyle> {
        isStandalone(): boolean;
        asNormal(): this;
        asStandalone(): this;
        static values(): Internal.TextStyle[];
        static valueOf(arg0: string): Internal.TextStyle;
        get standalone(): boolean
        static readonly SHORT: Internal.TextStyle;
        static readonly NARROW: Internal.TextStyle;
        static readonly SHORT_STANDALONE: Internal.TextStyle;
        static readonly FULL: Internal.TextStyle;
        static readonly NARROW_STANDALONE: Internal.TextStyle;
        static readonly FULL_STANDALONE: Internal.TextStyle;
    }
    type TextStyle_ = "narrow" | TextStyle | "short" | "full_standalone" | "short_standalone" | "full" | "narrow_standalone";
    interface Long2ObjectFunction <V> extends it.unimi.dsi.fastutil.Function<number, V>, Internal.LongFunction<V> {
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        composeShort(arg0: Internal.Short2LongFunction_): Internal.Short2ObjectFunction<V>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        composeByte(arg0: Internal.Byte2LongFunction_): Internal.Byte2ObjectFunction<V>;
        remove(arg0: number): V;
        composeReference<T>(arg0: Internal.Reference2LongFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Long2ByteFunction;
        composeDouble(arg0: Internal.Double2LongFunction_): Internal.Double2ObjectFunction<V>;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        put(arg0: number, arg1: V): V;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Long2ObjectFunction<T>;
        apply(arg0: number): V;
        composeFloat(arg0: Internal.Float2LongFunction_): Internal.Float2ObjectFunction<V>;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Long2LongFunction;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: V): V;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Long2IntFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Long2FloatFunction;
        composeLong(arg0: Internal.Long2LongFunction_): this;
        apply(arg0: number): V;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Long2ShortFunction;
        containsKey(arg0: number): boolean;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Long2DoubleFunction;
        composeObject<T>(arg0: Internal.Object2LongFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        abstract get(arg0: number): V;
        size(): number;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        composeInt(arg0: Internal.Int2LongFunction_): Internal.Int2ObjectFunction<V>;
        clear(): void;
        composeChar(arg0: Internal.Char2LongFunction_): Internal.Char2ObjectFunction<V>;
        defaultReturnValue(): V;
        getOrDefault(arg0: number, arg1: V): V;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Long2CharFunction;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Long2ReferenceFunction<T>;
        (arg0: number): V;
    }
    type Long2ObjectFunction_<V> = Long2ObjectFunction<V>;
    class Warden extends Internal.Monster implements Internal.VibrationSystem {
        constructor($$0: Internal.EntityType_<Internal.Monster>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        clearAnger($$0: Internal.Entity_): void;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        increaseAngerAt($$0: Internal.Entity_): void;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAngerLevel(): Internal.AngerLevel;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        static getResonanceEventByFrequency($$0: number): Internal.GameEvent;
        getTendrilAnimation($$0: number): number;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        static getRedstoneStrengthForDistance($$0: number, $$1: number): number;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getHeartAnimation($$0: number): number;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getAngerManagement(): Internal.AngerManagement;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getClientAngerLevel(): number;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        canTargetEntity($$0: Internal.Entity_): boolean;
        isMonster(): boolean;
        getType(): string;
        getBrain(): Internal.Brain<Internal.Warden>;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        setAttackTarget($$0: Internal.LivingEntity_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        static getGameEventFrequency($$0: Internal.GameEvent_): number;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getEntityAngryAt(): Internal.Optional<Internal.LivingEntity>;
        static applyDarknessAround($$0: Internal.ServerLevel_, $$1: Vec3d_, $$2: Internal.Entity_, $$3: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getVibrationUser(): Internal.VibrationSystem$User;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        increaseAngerAt($$0: Internal.Entity_, $$1: number, $$2: boolean): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        getVibrationData(): Internal.VibrationSystem$Data;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get angerLevel(): Internal.AngerLevel
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get angerManagement(): Internal.AngerManagement
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get clientAngerLevel(): number
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get brain(): Internal.Brain<Internal.Warden>
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        set attackTarget($$0: Internal.LivingEntity_)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        get entityAngryAt(): Internal.Optional<Internal.LivingEntity>
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get vibrationUser(): Internal.VibrationSystem$User
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get vibrationData(): Internal.VibrationSystem$Data
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        diggingAnimationState: Internal.AnimationState;
        sonicBoomAnimationState: Internal.AnimationState;
        attackAnimationState: Internal.AnimationState;
        roarAnimationState: Internal.AnimationState;
        emergeAnimationState: Internal.AnimationState;
        sniffAnimationState: Internal.AnimationState;
    }
    type Warden_ = Warden;
    interface IAutoCookingUpgradeItem {
        abstract getAutoCookingUpgradeConfig(): Internal.AutoCookingUpgradeConfig;
        get autoCookingUpgradeConfig(): Internal.AutoCookingUpgradeConfig
        (): Internal.AutoCookingUpgradeConfig_;
    }
    type IAutoCookingUpgradeItem_ = IAutoCookingUpgradeItem;
    class InflatePufferfishEffect implements Internal.PrestidigitationEffect {
        constructor()
        effectEntity(env: Internal.CastingEnvironment_, entity: Internal.Entity_): void;
        effectBlock(env: Internal.CastingEnvironment_, position: BlockPos_): void;
    }
    type InflatePufferfishEffect_ = InflatePufferfishEffect;
    interface CommentedConfig extends Internal.UnmodifiableCommentedConfig, Internal.Config {
        abstract add(arg0: Internal.List_<string>, arg1: any): boolean;
        getEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        of(arg0: Internal.Supplier_<Internal.Map<string, any>>, arg1: Internal.ConfigFormat_<Internal.CommentedConfig>): this;
        getEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T): T;
        getInt(arg0: Internal.List_<string>): number;
        getByteOrElse(arg0: string, arg1: number): number;
        getShortOrElse(arg0: string, arg1: number): number;
        abstract getComment(arg0: Internal.List_<string>): string;
        /**
         * @deprecated
        */
        abstract commentMap(): Internal.Map<string, string>;
        getShortOrElse(arg0: Internal.List_<string>, arg1: number): number;
        abstract containsComment(arg0: Internal.List_<string>): boolean;
        getIntOrElse(arg0: Internal.List_<string>, arg1: number): number;
        getOptionalComment(arg0: Internal.List_<string>): Internal.Optional<string>;
        abstract getRaw<T>(arg0: Internal.List_<string>): T;
        update(arg0: Internal.List_<string>, arg1: any): void;
        getOptionalLong(arg0: string): Internal.OptionalLong;
        remove<T>(arg0: string): T;
        createSubConfig(): Internal.Config;
        putAll(arg0: Internal.UnmodifiableConfig_): void;
        getEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T): T;
        add(arg0: string, arg1: any): boolean;
        copy(arg0: Internal.UnmodifiableConfig_, arg1: Internal.Supplier_<Internal.Map<string, any>>): this;
        copy(arg0: Internal.UnmodifiableConfig_, arg1: Internal.ConfigFormat_<any>): this;
        getComments(arg0: Internal.Map_<string, Internal.UnmodifiableCommentedConfig$CommentNode>): void;
        /**
         * @deprecated
        */
        concurrentCopy(arg0: Internal.UnmodifiableConfig_): this;
        fake(arg0: Internal.Config_): this;
        copy(arg0: Internal.UnmodifiableCommentedConfig_, arg1: Internal.Supplier_<Internal.Map<string, any>>, arg2: Internal.ConfigFormat_<Internal.CommentedConfig>): this;
        getOptionalLong(arg0: Internal.List_<string>): Internal.OptionalLong;
        get<T>(arg0: string): T;
        abstract contains(arg0: Internal.List_<string>): boolean;
        getLong(arg0: Internal.List_<string>): number;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): Internal.Optional<T>;
        apply<T>(arg0: Internal.List_<string>): T;
        getLongOrElse(arg0: Internal.List_<string>, arg1: Internal.LongSupplier_): number;
        getInt(arg0: string): number;
        copy(arg0: Internal.UnmodifiableConfig_): this;
        getComment(arg0: string): string;
        containsComment(arg0: string): boolean;
        inMemoryUniversal(): Internal.Config;
        getRaw<T>(arg0: string): T;
        getIntOrElse(arg0: string, arg1: Internal.IntSupplier_): number;
        removeComment(arg0: string): string;
        copy(arg0: Internal.UnmodifiableConfig_, arg1: Internal.Supplier_<Internal.Map<string, any>>, arg2: Internal.ConfigFormat_<any>): this;
        /**
         * @deprecated
        */
        concurrentCopy(arg0: Internal.UnmodifiableConfig_, arg1: Internal.ConfigFormat_<any>): this;
        isNull(arg0: string): boolean;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T): Internal.Optional<T>;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T): T;
        getByteOrElse(arg0: Internal.List_<string>, arg1: number): number;
        getLongOrElse(arg0: string, arg1: number): number;
        abstract setComment(arg0: Internal.List_<string>, arg1: string): string;
        getOptionalInt(arg0: string): Internal.OptionalInt;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: Internal.Supplier_<T>): T;
        unmodifiable(): Internal.UnmodifiableConfig;
        getIntOrElse(arg0: string, arg1: number): number;
        abstract removeComment(arg0: Internal.List_<string>): string;
        copy(arg0: Internal.UnmodifiableCommentedConfig_, arg1: Internal.Supplier_<Internal.Map<string, any>>): this;
        checked(): Internal.Config;
        getOptionalInt(arg0: Internal.List_<string>): Internal.OptionalInt;
        update(arg0: string, arg1: any): void;
        abstract size(): number;
        copy(arg0: Internal.UnmodifiableCommentedConfig_): this;
        abstract clear(): void;
        /**
         * @deprecated
        */
        abstract valueMap(): Internal.Map<string, any>;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: Internal.Supplier_<T>): T;
        /**
         * @deprecated
        */
        inMemoryConcurrent(): this;
        inMemory(): this;
        apply<T>(arg0: string): T;
        getOrElse<T>(arg0: string, arg1: T): T;
        getLong(arg0: string): number;
        get<T>(arg0: Internal.List_<string>): T;
        getCharOrElse(arg0: string, arg1: string): string;
        abstract set<T>(arg0: Internal.List_<string>, arg1: any): T;
        /**
         * @deprecated
        */
        inMemoryUniversalConcurrent(): Internal.Config;
        contains(arg0: string): boolean;
        set<T>(arg0: string, arg1: any): T;
        getShort(arg0: Internal.List_<string>): number;
        isNull(arg0: Internal.List_<string>): boolean;
        removeAll(arg0: Internal.UnmodifiableConfig_): void;
        setInsertionOrderPreserved(arg0: boolean): void;
        getOrElse<T>(arg0: Internal.List_<string>, arg1: Internal.Supplier_<T>): T;
        /**
         * @deprecated
        */
        getDefaultMapCreator<T>(arg0: boolean, arg1: boolean): Internal.Supplier<Internal.Map<string, T>>;
        getOptional<T>(arg0: Internal.List_<string>): Internal.Optional<T>;
        abstract remove<T>(arg0: Internal.List_<string>): T;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): Internal.Optional<T>;
        isInsertionOrderPreserved(): boolean;
        getOptional<T>(arg0: string): Internal.Optional<T>;
        getShort(arg0: string): number;
        getOrElse<T>(arg0: string, arg1: Internal.Supplier_<T>): T;
        putAllComments(arg0: Internal.UnmodifiableCommentedConfig_): void;
        abstract clearComments(): void;
        getComments(): Internal.Map<string, Internal.UnmodifiableCommentedConfig$CommentNode>;
        addAll(arg0: Internal.UnmodifiableConfig_): void;
        getChar(arg0: string): string;
        getOrElse<T>(arg0: Internal.List_<string>, arg1: T): T;
        /**
         * @deprecated
        */
        concurrentCopy(arg0: Internal.UnmodifiableCommentedConfig_, arg1: Internal.ConfigFormat_<any>): this;
        getChar(arg0: Internal.List_<string>): string;
        setComment(arg0: string, arg1: string): string;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_, arg3: Internal.Supplier_<T>): T;
        getLongOrElse(arg0: Internal.List_<string>, arg1: number): number;
        /**
         * @deprecated
        */
        concurrentCopy(arg0: Internal.UnmodifiableCommentedConfig_): this;
        isEmpty(): boolean;
        putAllComments(arg0: Internal.Map_<string, Internal.UnmodifiableCommentedConfig$CommentNode>): void;
        getIntOrElse(arg0: Internal.List_<string>, arg1: Internal.IntSupplier_): number;
        fake(arg0: Internal.UnmodifiableConfig_): Internal.UnmodifiableCommentedConfig;
        wrap(arg0: Internal.Map_<string, any>, arg1: Internal.ConfigFormat_<any>): this;
        /**
         * @deprecated
        */
        getDefaultMapCreator<T>(arg0: boolean): Internal.Supplier<Internal.Map<string, T>>;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        abstract entrySet(): Internal.Set<Internal.CommentedConfig$Entry>;
        getOptionalComment(arg0: string): Internal.Optional<string>;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T): T;
        getCharOrElse(arg0: Internal.List_<string>, arg1: string): string;
        getByte(arg0: Internal.List_<string>): number;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T): Internal.Optional<T>;
        /**
         * @deprecated
        */
        ofConcurrent(arg0: Internal.ConfigFormat_<Internal.CommentedConfig>): this;
        of(arg0: Internal.ConfigFormat_<Internal.CommentedConfig>): this;
        getLongOrElse(arg0: string, arg1: Internal.LongSupplier_): number;
        getByte(arg0: string): number;
        copy(arg0: Internal.UnmodifiableCommentedConfig_, arg1: Internal.ConfigFormat_<any>): this;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        abstract configFormat(): Internal.ConfigFormat<any>;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_, arg3: Internal.Supplier_<T>): T;
        getEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        set insertionOrderPreserved(arg0: boolean)
        get insertionOrderPreserved(): boolean
        get comments(): Internal.Map<string, Internal.UnmodifiableCommentedConfig$CommentNode>
        get empty(): boolean
    }
    type CommentedConfig_ = CommentedConfig;
    class ForgeConfigSpec$EnumValue <T extends Internal.Enum<T>> extends Internal.ForgeConfigSpec$ConfigValue<T> {
    }
    type ForgeConfigSpec$EnumValue_<T extends Internal.Enum<T>> = ForgeConfigSpec$EnumValue<T>;
    class PulleyBlock extends Internal.HorizontalAxisKineticBlock implements Internal.IBE<Internal.PulleyBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        getBlockEntityType(): Internal.BlockEntityType<Internal.PulleyBlockEntity>;
        setLightEmission(v: number): void;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.PulleyBlockEntity>): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.PulleyBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getBlockEntityClass(): typeof Internal.PulleyBlockEntity;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        showCapacityWithAnnotation(): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.PulleyBlockEntity;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.PulleyBlockEntity>;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityType(): Internal.BlockEntityType<Internal.PulleyBlockEntity>
        set lightEmission(v: number)
        get mod(): string
        get blockEntityClass(): typeof Internal.PulleyBlockEntity
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
    }
    type PulleyBlock_ = PulleyBlock;
    class EntitySectionStorage <T extends Internal.EntityAccess> implements Internal.MovementTrackerCache {
        constructor($$0: T, $$1: Internal.Long2ObjectFunction_<Internal.Visibility>)
        getExistingSectionsInChunk($$0: number): Internal.Stream<Internal.EntitySection<T>>;
        count(): number;
        getOrCreateSection($$0: number): Internal.EntitySection<T>;
        forEachAccessibleNonEmptySection($$0: Internal.AABB_, $$1: Internal.AbortableIterationConsumer_<Internal.EntitySection<T>>): void;
        getSection($$0: number): Internal.EntitySection<T>;
        remove($$0: number): void;
        getAllChunksWithExistingSections(): Internal.LongSet;
        getEntities<U extends T>($$0: Internal.EntityTypeTest_<T, U>, $$1: Internal.AABB_, $$2: Internal.AbortableIterationConsumer_<U>): void;
        deduplicate(tracker: Internal.SectionedEntityMovementTracker_<any, any>): Internal.SectionedEntityMovementTracker<any, any>;
        getExistingSectionPositionsInChunk($$0: number): Internal.LongStream;
        getEntities($$0: Internal.AABB_, $$1: Internal.AbortableIterationConsumer_<T>): void;
        handler$ejh000$lithium$forEachInBox(box: Internal.AABB_, action: Internal.AbortableIterationConsumer_<any>, ci: Internal.CallbackInfo_, i: number, minX: number, minY: number, minZ: number, maxX: number, maxY: number, maxZ: number): void;
        remove(tracker: Internal.SectionedEntityMovementTracker_<any, any>): void;
        get allChunksWithExistingSections(): Internal.LongSet
    }
    type EntitySectionStorage_<T extends Internal.EntityAccess> = EntitySectionStorage<T>;
    interface CoreGeoModel <E extends Internal.GeoAnimatable> {
        abstract handleAnimations(arg0: E, arg1: number, arg2: software.bernie.geckolib.core.animation.AnimationState_<E>): void;
        abstract getBakedGeoModel(arg0: string): Internal.CoreBakedGeoModel;
        abstract getAnimationProcessor(): Internal.AnimationProcessor<E>;
        setCustomAnimations(animatable: E, instanceId: number, animationState: software.bernie.geckolib.core.animation.AnimationState_<E>): void;
        abstract getAnimation(arg0: E, arg1: string): software.bernie.geckolib.core.animation.Animation;
        applyMolangQueries(animatable: E, animTime: number): void;
        getBone(name: string): Internal.Optional<Internal.CoreGeoBone>;
        get animationProcessor(): Internal.AnimationProcessor<E>
    }
    type CoreGeoModel_<E extends Internal.GeoAnimatable> = CoreGeoModel<E>;
    class MountedStorageSyncPacket extends Internal.SimplePacketBase {
        constructor(buf: Internal.FriendlyByteBuf_)
        constructor(contraptionId: number, items: Internal.Map_<BlockPos, Internal.MountedItemStorage>, fluids: Internal.Map_<BlockPos, Internal.MountedFluidStorage>)
        readonly contraptionId: number;
        readonly fluids: Internal.Map<BlockPos, Internal.MountedFluidStorage>;
        readonly items: Internal.Map<BlockPos, Internal.MountedItemStorage>;
    }
    type MountedStorageSyncPacket_ = MountedStorageSyncPacket;
    interface IDropArmor {
        abstract dropArmor(): void;
        (): void;
    }
    type IDropArmor_ = IDropArmor;
    class VibrationChamberBlock extends Internal.AEBaseEntityBlock<any> {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly ACTIVE: Internal.BooleanProperty;
    }
    type VibrationChamberBlock_ = VibrationChamberBlock;
    interface TagType <T extends Internal.Tag> {
        abstract getPrettyName(): string;
        abstract skip(arg0: Internal.DataInput_, arg1: number): void;
        parseRoot($$0: Internal.DataInput_, $$1: Internal.StreamTagVisitor_): void;
        isValue(): boolean;
        abstract getName(): string;
        createInvalid($$0: number): Internal.TagType<Internal.EndTag>;
        abstract parse(arg0: Internal.DataInput_, arg1: Internal.StreamTagVisitor_): Internal.StreamTagVisitor$ValueResult;
        abstract load(arg0: Internal.DataInput_, arg1: number, arg2: Internal.NbtAccounter_): T;
        abstract skip(arg0: Internal.DataInput_): void;
        get prettyName(): string
        get value(): boolean
        get name(): string
    }
    type TagType_<T extends Internal.Tag> = TagType<T>;
    abstract class AbstractFurnaceMenu extends Internal.RecipeBookMenu<net.minecraft.world.Container> {
        isLit(): boolean;
        getBurnProgress(): number;
        getLitProgress(): number;
        get lit(): boolean
        get burnProgress(): number
        get litProgress(): number
        static readonly FUEL_SLOT: 1;
        static readonly RESULT_SLOT: 2;
        static readonly DATA_COUNT: 4;
        static readonly SLOT_COUNT: 3;
        static readonly INGREDIENT_SLOT: 0;
    }
    type AbstractFurnaceMenu_ = AbstractFurnaceMenu;
    class TreeDecoratorType <P extends Internal.TreeDecorator> {
        constructor($$0: Internal.Codec_<P>)
        codec(): Internal.Codec<P>;
        static readonly BEEHIVE: Internal.TreeDecoratorType<Internal.BeehiveDecorator>;
        static readonly LEAVE_VINE: Internal.TreeDecoratorType<Internal.LeaveVineDecorator>;
        static readonly COCOA: Internal.TreeDecoratorType<Internal.CocoaDecorator>;
        static readonly TRUNK_VINE: Internal.TreeDecoratorType<Internal.TrunkVineDecorator>;
        static readonly ALTER_GROUND: Internal.TreeDecoratorType<Internal.AlterGroundDecorator>;
        static readonly ATTACHED_TO_LEAVES: Internal.TreeDecoratorType<Internal.AttachedToLeavesDecorator>;
    }
    type TreeDecoratorType_<P extends Internal.TreeDecorator> = TreeDecoratorType<P> | Special.TreeDecoratorType;
    abstract class MultithreadEventLoopGroup extends Internal.MultithreadEventExecutorGroup implements Internal.EventLoopGroup {
        register(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract schedule<V>(arg0: Internal.Callable_<V>, arg1: number, arg2: Internal.TimeUnit_): io.netty.util.concurrent.ScheduledFuture<V>;
        abstract submit<T>(arg0: Internal.Runnable_, arg1: T): io.netty.util.concurrent.Future<T>;
        register(arg0: io.netty.channel.Channel_): Internal.ChannelFuture;
        forEach(arg0: Internal.Consumer_<Internal.EventExecutor>): void;
        close(): void;
        /**
         * @deprecated
        */
        register(arg0: io.netty.channel.Channel_, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract submit<T>(arg0: Internal.Callable_<T>): io.netty.util.concurrent.Future<T>;
        spliterator(): Internal.Spliterator<Internal.EventExecutor>;
    }
    type MultithreadEventLoopGroup_ = MultithreadEventLoopGroup;
    class ListConfig <E, CV extends Internal.ConfigValue<E>> extends Internal.ConfigValue<Internal.List<E>> {
        constructor(t: CV)
        getColor(v: Internal.List_<E>): Internal.Color4I;
        getStringForGUI(v: Internal.List_<E>): net.minecraft.network.chat.Component;
        copy(arg0: any): any;
        getType(): CV;
        copy(v: Internal.List_<E>): Internal.List<E>;
        get type(): CV
        static readonly COLOR: Internal.Color4I;
        static readonly NON_EMPTY_LIST: Internal.MutableComponent;
        static readonly EMPTY_LIST: Internal.MutableComponent;
    }
    type ListConfig_<E, CV extends Internal.ConfigValue<E>> = ListConfig<E, CV>;
    class SmallFireball extends Internal.Fireball {
        constructor($$0: Internal.EntityType_<Internal.SmallFireball>, $$1: Internal.Level_)
        constructor($$0: Internal.Level_, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number)
        constructor($$0: Internal.Level_, $$1: Internal.LivingEntity_, $$2: number, $$3: number, $$4: number)
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
    }
    type SmallFireball_ = SmallFireball;
    abstract class ModelProvider <T extends Internal.ModelBuilder<T>> implements Internal.DataProvider {
        constructor(output: Internal.PackOutput_, modid: string, folder: string, builderFromModId: Internal.BiFunction_<ResourceLocation, Internal.ExistingFileHelper, T>, existingFileHelper: Internal.ExistingFileHelper_)
        constructor(output: Internal.PackOutput_, modid: string, folder: string, factory: Internal.Function_<ResourceLocation, T>, existingFileHelper: Internal.ExistingFileHelper_)
        doorTopLeftOpen(name: string, bottom: ResourceLocation_, top: ResourceLocation_): T;
        fenceGate(name: string, texture: ResourceLocation_): T;
        getBuilder(path: string): T;
        static saveStable($$0: Internal.CachedOutput_, $$1: Internal.JsonElement_, $$2: Internal.Path_): Internal.CompletableFuture<any>;
        slab(name: string, side: ResourceLocation_, bottom: ResourceLocation_, top: ResourceLocation_): T;
        generateAll(cache: Internal.CachedOutput_): Internal.CompletableFuture<any>;
        paneSideAlt(name: string, pane: ResourceLocation_, edge: ResourceLocation_): T;
        fenceGateWallOpen(name: string, texture: ResourceLocation_): T;
        trapdoorOrientableOpen(name: string, texture: ResourceLocation_): T;
        pressurePlate(name: string, texture: ResourceLocation_): T;
        trapdoorOrientableBottom(name: string, texture: ResourceLocation_): T;
        fenceGateOpen(name: string, texture: ResourceLocation_): T;
        doorBottomRight(name: string, bottom: ResourceLocation_, top: ResourceLocation_): T;
        slabTop(name: string, side: ResourceLocation_, bottom: ResourceLocation_, top: ResourceLocation_): T;
        stairs(name: string, side: ResourceLocation_, bottom: ResourceLocation_, top: ResourceLocation_): T;
        fencePost(name: string, texture: ResourceLocation_): T;
        withExistingParent(name: string, parent: string): T;
        modLoc(name: string): ResourceLocation;
        singleTexture(name: string, parent: ResourceLocation_, textureKey: string, texture: ResourceLocation_): T;
        stairsInner(name: string, side: ResourceLocation_, bottom: ResourceLocation_, top: ResourceLocation_): T;
        mcLoc(name: string): ResourceLocation;
        fenceInventory(name: string, texture: ResourceLocation_): T;
        cross(name: string, cross: ResourceLocation_): T;
        stairsOuter(name: string, side: ResourceLocation_, bottom: ResourceLocation_, top: ResourceLocation_): T;
        getExistingFile(path: ResourceLocation_): Internal.ModelFile$ExistingModelFile;
        paneSide(name: string, pane: ResourceLocation_, edge: ResourceLocation_): T;
        doorBottomRightOpen(name: string, bottom: ResourceLocation_, top: ResourceLocation_): T;
        wallPost(name: string, wall: ResourceLocation_): T;
        paneNoSideAlt(name: string, pane: ResourceLocation_): T;
        cubeBottomTop(name: string, side: ResourceLocation_, bottom: ResourceLocation_, top: ResourceLocation_): T;
        withExistingParent(name: string, parent: ResourceLocation_): T;
        doorBottomLeftOpen(name: string, bottom: ResourceLocation_, top: ResourceLocation_): T;
        wallSide(name: string, wall: ResourceLocation_): T;
        orientableWithBottom(name: string, side: ResourceLocation_, front: ResourceLocation_, bottom: ResourceLocation_, top: ResourceLocation_): T;
        button(name: string, texture: ResourceLocation_): T;
        orientableVertical(name: string, side: ResourceLocation_, front: ResourceLocation_): T;
        nested(): T;
        buttonInventory(name: string, texture: ResourceLocation_): T;
        paneNoSide(name: string, pane: ResourceLocation_): T;
        doorTopRightOpen(name: string, bottom: ResourceLocation_, top: ResourceLocation_): T;
        doorTopLeft(name: string, bottom: ResourceLocation_, top: ResourceLocation_): T;
        sign(name: string, texture: ResourceLocation_): T;
        crop(name: string, crop: ResourceLocation_): T;
        fenceSide(name: string, texture: ResourceLocation_): T;
        torch(name: string, torch: ResourceLocation_): T;
        abstract getName(): string;
        cubeColumn(name: string, side: ResourceLocation_, end: ResourceLocation_): T;
        orientable(name: string, side: ResourceLocation_, front: ResourceLocation_, top: ResourceLocation_): T;
        doorTopRight(name: string, bottom: ResourceLocation_, top: ResourceLocation_): T;
        wallInventory(name: string, wall: ResourceLocation_): T;
        torchWall(name: string, torch: ResourceLocation_): T;
        doorBottomLeft(name: string, bottom: ResourceLocation_, top: ResourceLocation_): T;
        cube(name: string, down: ResourceLocation_, up: ResourceLocation_, north: ResourceLocation_, south: ResourceLocation_, east: ResourceLocation_, west: ResourceLocation_): T;
        carpet(name: string, wool: ResourceLocation_): T;
        trapdoorOpen(name: string, texture: ResourceLocation_): T;
        singleTexture(name: string, parent: ResourceLocation_, texture: ResourceLocation_): T;
        buttonPressed(name: string, texture: ResourceLocation_): T;
        cubeColumnHorizontal(name: string, side: ResourceLocation_, end: ResourceLocation_): T;
        panePost(name: string, pane: ResourceLocation_, edge: ResourceLocation_): T;
        wallSideTall(name: string, wall: ResourceLocation_): T;
        cubeAll(name: string, texture: ResourceLocation_): T;
        run(cache: Internal.CachedOutput_): Internal.CompletableFuture<any>;
        trapdoorTop(name: string, texture: ResourceLocation_): T;
        pressurePlateDown(name: string, texture: ResourceLocation_): T;
        clear(): void;
        cubeTop(name: string, side: ResourceLocation_, top: ResourceLocation_): T;
        trapdoorBottom(name: string, texture: ResourceLocation_): T;
        fenceGateWall(name: string, texture: ResourceLocation_): T;
        trapdoorOrientableTop(name: string, texture: ResourceLocation_): T;
        get name(): string
        readonly existingFileHelper: Internal.ExistingFileHelper;
        static readonly ITEM_FOLDER: "item";
        static readonly BLOCK_FOLDER: "block";
        readonly generatedModels: Internal.Map<ResourceLocation, T>;
    }
    type ModelProvider_<T extends Internal.ModelBuilder<T>> = ModelProvider<T>;
    class ImmutableEnumMap <K extends Internal.Enum<K>, V> extends Internal.ImmutableMap$IteratorBasedImmutableMap<K, V> {
        get(arg0: any): V;
        static entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
    }
    type ImmutableEnumMap_<K extends Internal.Enum<K>, V> = ImmutableEnumMap<K, V>;
    class Pack$Info extends Internal.Record {
        constructor($$0: net.minecraft.network.chat.Component_, $$1: number, $$2: Internal.FeatureFlagSet_)
        description(): net.minecraft.network.chat.Component;
        format(): number;
        requestedFeatures(): Internal.FeatureFlagSet;
        compatibility($$0: Internal.PackType_): Internal.PackCompatibility;
    }
    type Pack$Info_ = Pack$Info;
    interface MinecraftServerKJS extends Internal.DataSenderKJS, Internal.MinecraftEnvironmentKJS, Internal.WithPersistentData, Internal.WithAttachedData<Internal.MinecraftServer> {
        getDisplayName(): net.minecraft.network.chat.Component;
        getPersistentData(): Internal.CompoundTag;
        scheduleInTicks(ticks: number, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        getName(): net.minecraft.network.chat.Component;
        getPlayer(selector: Internal.PlayerSelector_): Internal.ServerPlayer;
        self(): Internal.MinecraftServer;
        runCommandSilent(command: string): number;
        getEntities(): Internal.EntityArrayList;
        scheduleRepeatingInTicks(ticks: number, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        sendData(channel: string): void;
        abstract getScheduledEvents(): Internal.ScheduledEvents;
        tell(message: net.minecraft.network.chat.Component_): void;
        sendData(channel: string, data: Internal.CompoundTag_): void;
        schedule(timer: Internal.TemporalAmount_, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        getAdvancement(id: ResourceLocation_): Internal.AdvancementJS;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        abstract getData(): Internal.AttachedData<Internal.MinecraftServer>;
        restoreInventories(): Internal.Map<Internal.UUID, Internal.Map<number, Internal.ItemStack>>;
        getPlayers(): Internal.EntityArrayList;
        scheduleRepeating(timer: Internal.TemporalAmount_, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        runCommand(command: string): number;
        abstract getReloadableResources(): Internal.MinecraftServer$ReloadableResources;
        getLevel(dimension: ResourceLocation_): Internal.ServerLevel;
        abstract getOverworld(): Internal.ServerLevel;
        get displayName(): net.minecraft.network.chat.Component
        get persistentData(): Internal.CompoundTag
        get name(): net.minecraft.network.chat.Component
        get entities(): Internal.EntityArrayList
        get scheduledEvents(): Internal.ScheduledEvents
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get data(): Internal.AttachedData<Internal.MinecraftServer>
        get players(): Internal.EntityArrayList
        get reloadableResources(): Internal.MinecraftServer$ReloadableResources
        get overworld(): Internal.ServerLevel
    }
    type MinecraftServerKJS_ = MinecraftServerKJS;
    class JukeboxUpgradeWrapper extends Internal.UpgradeWrapperBase<Internal.JukeboxUpgradeWrapper, Internal.JukeboxUpgradeItem> implements Internal.ITickableUpgrade {
        previous(): void;
        play(level: Internal.Level_, pos: BlockPos_): void;
        setRepeatMode(repeatMode: Internal.RepeatMode_): void;
        playNext(): void;
        getRepeatMode(): Internal.RepeatMode;
        stop(entity: Internal.LivingEntity_): void;
        tick(entity: Internal.Entity_, level: Internal.Level_, pos: BlockPos_): void;
        playPrevious(): void;
        getDiscSlotActive(): number;
        play(entity: Internal.Entity_): void;
        next(): void;
        canBeDisabled(): boolean;
        isPlaying(): boolean;
        setShuffleEnabled(shuffleEnabled: boolean): void;
        hideSettingsTab(): boolean;
        getDiscInventory(): io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
        getDiscFinishTime(): number;
        playNext(startOverIfAtTheEnd: boolean): void;
        getDisc(): Internal.ItemStack;
        getDiscLength(): number;
        onAdded(): void;
        isShuffleEnabled(): boolean;
        set repeatMode(repeatMode: Internal.RepeatMode_)
        get repeatMode(): Internal.RepeatMode
        get discSlotActive(): number
        get playing(): boolean
        set shuffleEnabled(shuffleEnabled: boolean)
        get discInventory(): io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler
        get discFinishTime(): number
        get disc(): Internal.ItemStack
        get discLength(): number
        get shuffleEnabled(): boolean
    }
    type JukeboxUpgradeWrapper_ = JukeboxUpgradeWrapper;
    class PaintBallItem extends Internal.AEBaseItem {
        constructor(properties: Internal.Item$Properties_, color: Internal.AEColor_, lumen: boolean)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getColor(): Internal.AEColor;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        isLumen(): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        get color(): Internal.AEColor
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get lumen(): boolean
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type PaintBallItem_ = PaintBallItem;
    class ClipBlockStateContext {
        constructor($$0: Vec3d_, $$1: Vec3d_, $$2: Internal.Predicate_<Internal.BlockState>)
        getFrom(): Vec3d;
        getTo(): Vec3d;
        isTargetBlock(): Internal.Predicate<Internal.BlockState>;
        get from(): Vec3d
        get to(): Vec3d
    }
    type ClipBlockStateContext_ = ClipBlockStateContext;
    class ICustomParticleData$1 extends Internal.ParticleType<T> {
        codec(): Internal.Codec<T>;
    }
    type ICustomParticleData$1_ = ICustomParticleData$1;
    interface MapEncoder <A> extends Internal.Keyable {
        flatComap<B>(arg0: Internal.Function_<B, Internal.DataResult<A>>): Internal.MapEncoder<B>;
        abstract compressor<T>(arg0: Internal.DynamicOps_<T>): Internal.KeyCompressor<T>;
        abstract encode<T>(arg0: A, arg1: Internal.DynamicOps_<T>, arg2: Internal.RecordBuilder_<T>): Internal.RecordBuilder<T>;
        compressedBuilder<T>(arg0: Internal.DynamicOps_<T>): Internal.RecordBuilder<T>;
        comap<B>(arg0: Internal.Function_<B, A>): Internal.MapEncoder<B>;
        encoder(): Internal.Encoder<A>;
        withLifecycle(arg0: Internal.Lifecycle_): this;
        makeCompressedBuilder<T>(arg0: Internal.DynamicOps_<T>, arg1: Internal.KeyCompressor_<T>): Internal.RecordBuilder<T>;
        abstract keys<T>(arg0: Internal.DynamicOps_<T>): Internal.Stream<T>;
        forStrings(arg0: Internal.Supplier_<Internal.Stream<string>>): Internal.Keyable;
    }
    type MapEncoder_<A> = MapEncoder<A>;
    class Mishap$Companion {
        constructor($constructor_marker: any_)
        trulyHurt(entity: Internal.LivingEntity_, source: DamageSource_, amount: number): void;
    }
    type Mishap$Companion_ = Mishap$Companion;
    interface PersistentEntitySectionManagerHooks {
        abstract architectury_attachLevel(arg0: Internal.ServerLevel_): void;
        (arg0: Internal.ServerLevel): void;
    }
    type PersistentEntitySectionManagerHooks_ = PersistentEntitySectionManagerHooks;
    class DeployerFakePlayer extends Internal.FakePlayer {
        constructor(world: Internal.ServerLevel_, owner: Internal.UUID_)
        static deployerKillsDoNotSpawnXP(i: number, player: Internal.Player_, entity: Internal.LivingEntity_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        getDistance(pos: BlockPos_): number;
        isFake(): boolean;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        getStats(): Internal.PlayerStatsJS;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        abstract etf$getType(): Internal.EntityType<any>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        getSpawnLocation(): Internal.BlockContainerJS;
        static deployerCollectsDropsFromKilledEntities(target: Internal.LivingEntity_, source: DamageSource_, drops: Internal.Collection_<Internal.ItemEntity>, lootingLevel: number, recentlyHit: boolean): boolean;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        addFood(f: number, m: number): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        setSpawnLocation(c: Internal.BlockContainerJS_): void;
        captureInventory(autoRestore: boolean): net.minecraft.world.Container;
        swing(): void;
        getEntityReach(): number;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        getXpLevel(): number;
        canReach(pos: BlockPos_, padding: number): boolean;
        clearMeshes(): void;
        openGUI(gui: Internal.Consumer_<Internal.KubeJSGUI>): void;
        setSelectedSlot(index: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        isOp(): boolean;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        kick(): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        paint(renderer: Internal.CompoundTag_): void;
        getBlockReach(): number;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getAnimation(): Internal.AnimationApplier;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getFoodLevel(): number;
        openChestGUI(title: net.minecraft.network.chat.Component_, rows: number, gui: Internal.Consumer_<Internal.ChestMenuData>): void;
        notify(title: net.minecraft.network.chat.Component_, text: net.minecraft.network.chat.Component_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        setXpLevel(l: number): void;
        canRiderInteract(): boolean;
        setFoodLevel(foodLevel: number): void;
        setSaturation(saturation: number): void;
        addXPLevels(l: number): void;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        canReach(entity: Internal.Entity_, padding: number): boolean;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        abstract etf$getArmorItems(): Internal.Iterable<Internal.ItemStack>;
        sendData(channel: string): void;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        abstract etf$getItemsEquipped(): Internal.Iterable<Internal.ItemStack>;
        getSelectedSlot(): number;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        getOpenInventory(): Internal.AbstractContainerMenu;
        getXp(): number;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        setXp(xp: number): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        setCreativeMode(mode: boolean): void;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        isMiningBlock(): boolean;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        notify(builder: Notification_): void;
        isMonster(): boolean;
        static entitiesDontRetaliate(event: Internal.LivingEntityEvents$ChangeTarget$ChangeTargetEvent_): void;
        sophisticatedCore_openMenu(menuProvider: Internal.MenuProvider_, pos: BlockPos_): Internal.OptionalInt;
        getType(): string;
        setChestArmorItem(item: Internal.ItemStack_): void;
        sophisticatedCore_openMenu(menu: Internal.MenuProvider_, context: Internal.Consumer_<Internal.FriendlyByteBuf>): Internal.OptionalInt;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        isCloseEnough(entity: Internal.Entity_, dist: number): boolean;
        getName(): net.minecraft.network.chat.Component;
        boostElytraFlight(): void;
        addExhaustion(exhaustion: number): void;
        getPassengers(): Internal.EntityArrayList;
        self(): Internal.ServerPlayer;
        giveInHand(item: Internal.ItemStack_): void;
        setMouseItem(item: Internal.ItemStack_): void;
        setTotalMovementSpeedMultiplier(speed: number): void;
        static deployerHasEyesOnHisFeet(event: Internal.EntityEvents$Size_): void;
        ban(banner: string, reason: string, expiresInMillis: number): void;
        sophisticatedInvalidateCaps(): void;
        sendData(channel: string, data: Internal.CompoundTag_): void;
        addXP(xp: number): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        give(item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        revokeAdvancement(id: ResourceLocation_): void;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getDigSpeed(state: Internal.BlockState_, pos: BlockPos_): number;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        spawn(): void;
        getMainHandItem(): Internal.ItemStack;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        kick(reason: net.minecraft.network.chat.Component_): void;
        canReach(entityHitVec: Vec3d_, padding: number): boolean;
        isAdvancementDone(id: ResourceLocation_): boolean;
        sendInventoryUpdate(): void;
        abstract etf$getHandItems(): Internal.Iterable<Internal.ItemStack>;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        unlockAdvancement(id: ResourceLocation_): void;
        getMouseItem(): Internal.ItemStack;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        openInventoryGUI(inventory: Internal.InventoryKJS_, title: net.minecraft.network.chat.Component_): void;
        getProfile(): Internal.GameProfile;
        getSaturation(): number;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        static getPlayerModelParts(): Internal.EntityDataAccessor<number>;
        addItemCooldown(item: Internal.Item_, ticks: number): void;
        get fake(): boolean
        get stats(): Internal.PlayerStatsJS
        set defaultMovementSpeedMultiplier(speed: number)
        get spawnLocation(): Internal.BlockContainerJS
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        set spawnLocation(c: Internal.BlockContainerJS_)
        get entityReach(): number
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get xpLevel(): number
        set selectedSlot(index: number)
        get living(): boolean
        get op(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get blockReach(): number
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        get animation(): Internal.AnimationApplier
        get foodLevel(): number
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        set xpLevel(l: number)
        set foodLevel(foodLevel: number)
        set saturation(saturation: number)
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get selectedSlot(): number
        get potionEffects(): Internal.EntityPotionEffectsJS
        get openInventory(): Internal.AbstractContainerMenu
        get xp(): number
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        set xp(xp: number)
        set creativeMode(mode: boolean)
        get defaultMovementSpeed(): number
        get miningBlock(): boolean
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set mouseItem(item: Internal.ItemStack_)
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        get mouseItem(): Internal.ItemStack
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        get saturation(): number
        set headArmorItem(item: Internal.ItemStack_)
        get playerModelParts(): Internal.EntityDataAccessor<number>
        static readonly fallbackID: Internal.UUID;
        onMinecartContraption: boolean;
        placedTracks: boolean;
    }
    type DeployerFakePlayer_ = DeployerFakePlayer;
    class TransientEntitySectionManager <T extends Internal.EntityAccess> implements me.jellysquid.mods.lithium.mixin.chunk.entity_class_groups.ClientEntityManagerAccessor<any>, Internal.ClientEntityManagerAccessor {
        constructor($$0: T, $$1: any_<T>)
        startTicking($$0: Internal.ChunkPos_): void;
        gatherStats(): string;
        count(): number;
        getEntityGetter(): Internal.LevelEntityGetter<T>;
        getCache(): Internal.EntitySectionStorage<any>;
        stopTicking($$0: Internal.ChunkPos_): void;
        addEntity($$0: T): void;
        getIndex(): Internal.EntityLookup<any>;
        get entityGetter(): Internal.LevelEntityGetter<T>
        get cache(): Internal.EntitySectionStorage<any>
        get index(): Internal.EntityLookup<any>
    }
    type TransientEntitySectionManager_<T extends Internal.EntityAccess> = TransientEntitySectionManager<T>;
    class StringArgumentSerializer implements Internal.ArgumentTypeInfo<Internal.StringArgumentType, Internal.StringArgumentSerializer$Template> {
        constructor()
        deserializeFromNetwork(arg0: Internal.FriendlyByteBuf_): Internal.ArgumentTypeInfo$Template<any>;
        unpack(arg0: Internal.ArgumentType_<any>): Internal.ArgumentTypeInfo$Template<any>;
        serializeToNetwork($$0: Internal.StringArgumentSerializer$Template_, $$1: Internal.FriendlyByteBuf_): void;
        deserializeFromNetwork($$0: Internal.FriendlyByteBuf_): Internal.StringArgumentSerializer$Template;
        unpack($$0: Internal.StringArgumentType_): Internal.StringArgumentSerializer$Template;
        serializeToNetwork(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.FriendlyByteBuf_): void;
        serializeToJson(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.JsonObject_): void;
        serializeToJson($$0: Internal.StringArgumentSerializer$Template_, $$1: Internal.JsonObject_): void;
    }
    type StringArgumentSerializer_ = StringArgumentSerializer;
    class GeneratedSlotWidget extends Internal.SlotWidget {
        constructor(stackSupplier: Internal.Function_<Internal.Random, Internal.EmiIngredient>, unique: number, x: number, y: number)
    }
    type GeneratedSlotWidget_ = GeneratedSlotWidget;
    class JobAttributes$DialogType extends Internal.AttributeValue {
        static readonly NATIVE: Internal.JobAttributes$DialogType;
        static readonly NONE: Internal.JobAttributes$DialogType;
        static readonly COMMON: Internal.JobAttributes$DialogType;
    }
    type JobAttributes$DialogType_ = JobAttributes$DialogType;
    class SequencedAssemblySubCategoryType extends Internal.Record {
        constructor(jei: Internal.Supplier_<Internal.Supplier<Internal.JeiSequencedAssemblySubCategory>>, rei: Internal.Supplier_<Internal.Supplier<Internal.ReiSequencedAssemblySubCategory>>, emi: Internal.Supplier_<Internal.Supplier<Internal.EmiSequencedAssemblySubCategory>>)
        rei(): Internal.Supplier<Internal.Supplier<Internal.ReiSequencedAssemblySubCategory>>;
        jei(): Internal.Supplier<Internal.Supplier<Internal.JeiSequencedAssemblySubCategory>>;
        emi(): Internal.Supplier<Internal.Supplier<Internal.EmiSequencedAssemblySubCategory>>;
        static readonly DEPLOYING: Internal.SequencedAssemblySubCategoryType;
        static readonly PRESSING: Internal.SequencedAssemblySubCategoryType;
        static readonly CUTTING: Internal.SequencedAssemblySubCategoryType;
        static readonly SPOUTING: Internal.SequencedAssemblySubCategoryType;
    }
    type SequencedAssemblySubCategoryType_ = SequencedAssemblySubCategoryType;
    abstract class SmartBlockEntity extends Internal.CachedRenderBBBlockEntity implements Internal.SpecialBlockEntityItemRequirement, Internal.PartialSafeNBT, Internal.ChunkUnloadListeningBlockEntity, Internal.IInteractionChecker, Internal.VirtualBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getBehaviour<T extends Internal.BlockEntityBehaviour>(type: Internal.BehaviourType_<T>): T;
        sendToMenu(buffer: Internal.FriendlyByteBuf_): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        method_11007(tag: Internal.CompoundTag_): void;
        destroy(): void;
        abstract addBehaviours(arg0: Internal.List_<Internal.BlockEntityBehaviour>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        onChunkUnloaded(): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        attachBehaviourLate(behaviour: Internal.BlockEntityBehaviour_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        addBehavioursDeferred(behaviours: Internal.List_<Internal.BlockEntityBehaviour>): void;
        isVirtual(): boolean;
        isChunkUnloaded(): boolean;
        getRequiredItems(state: Internal.BlockState_): Internal.ItemRequirement;
        remove(): void;
        removeBehaviour(type: Internal.BehaviourType_<any>): void;
        award(advancement: Internal.CreateAdvancement_): void;
        onLoad(): void;
        setLazyTickRate(slowTickRate: number): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        awardIfNear(advancement: Internal.CreateAdvancement_, range: number): void;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        initialize(): void;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        markVirtual(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        forEachBehaviour(action: Internal.Consumer_<Internal.BlockEntityBehaviour>): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAllBehaviours(): Internal.Collection<Internal.BlockEntityBehaviour>;
        invalidate(): void;
        writeSafe(tag: Internal.CompoundTag_): void;
        tick(): void;
        canPlayerUse(player: Internal.Player_): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        registerAwardables(behaviours: Internal.List_<Internal.BlockEntityBehaviour>, ...advancements: Internal.CreateAdvancement_[]): void;
        lazyTick(): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        refreshBlockState(): void;
        get virtual(): boolean
        get chunkUnloaded(): boolean
        set lazyTickRate(slowTickRate: number)
        get allBehaviours(): Internal.Collection<Internal.BlockEntityBehaviour>
        get infiniteBoundingBox(): Internal.AABB
    }
    type SmartBlockEntity_ = SmartBlockEntity;
    class Visibility extends Internal.Enum<Internal.Visibility> {
        isTicking(): boolean;
        static valueOf($$0: string): Internal.Visibility;
        static fromFullChunkStatus($$0: Internal.FullChunkStatus_): Internal.Visibility;
        static values(): Internal.Visibility[];
        isAccessible(): boolean;
        get ticking(): boolean
        get accessible(): boolean
        static readonly HIDDEN: Internal.Visibility;
        static readonly TRACKED: Internal.Visibility;
        static readonly TICKING: Internal.Visibility;
    }
    type Visibility_ = Visibility | "tracked" | "hidden" | "ticking";
    class UnderwaterMagmaConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: number, $$1: number, $$2: number)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        readonly floorSearchRange: number;
        readonly placementRadiusAroundFloor: number;
        static readonly CODEC: Internal.Codec<Internal.UnderwaterMagmaConfiguration>;
        readonly placementProbabilityPerValidPosition: number;
    }
    type UnderwaterMagmaConfiguration_ = UnderwaterMagmaConfiguration;
    interface SpriteFinder {
        /**
         * @deprecated
        */
        find(quad: Internal.QuadView_, textureIndex: number): Internal.TextureAtlasSprite;
        get(atlas: Internal.TextureAtlas_): this;
        abstract find(arg0: number, arg1: number): Internal.TextureAtlasSprite;
        abstract find(arg0: Internal.QuadView_): Internal.TextureAtlasSprite;
    }
    type SpriteFinder_ = SpriteFinder;
    interface ClientboundBossEventPacket$Handler {
        updateStyle($$0: Internal.UUID_, $$1: Internal.BossEvent$BossBarColor_, $$2: Internal.BossEvent$BossBarOverlay_): void;
        remove($$0: Internal.UUID_): void;
        updateProgress($$0: Internal.UUID_, $$1: number): void;
        updateProperties($$0: Internal.UUID_, $$1: boolean, $$2: boolean, $$3: boolean): void;
        add($$0: Internal.UUID_, $$1: net.minecraft.network.chat.Component_, $$2: number, $$3: Internal.BossEvent$BossBarColor_, $$4: Internal.BossEvent$BossBarOverlay_, $$5: boolean, $$6: boolean, $$7: boolean): void;
        updateName($$0: Internal.UUID_, $$1: net.minecraft.network.chat.Component_): void;
    }
    type ClientboundBossEventPacket$Handler_ = ClientboundBossEventPacket$Handler;
    class ProcessingRecipeBuilder$ProcessingRecipeParams {
        keepHeldItem: boolean;
    }
    type ProcessingRecipeBuilder$ProcessingRecipeParams_ = ProcessingRecipeBuilder$ProcessingRecipeParams;
    class ClientboundMerchantOffersPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: number, $$1: Internal.MerchantOffers_, $$2: number, $$3: number, $$4: boolean, $$5: boolean)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        showProgress(): boolean;
        getVillagerLevel(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        canRestock(): boolean;
        getOffers(): Internal.MerchantOffers;
        getContainerId(): number;
        getVillagerXp(): number;
        isSkippable(): boolean;
        get villagerLevel(): number
        get offers(): Internal.MerchantOffers
        get containerId(): number
        get villagerXp(): number
        get skippable(): boolean
    }
    type ClientboundMerchantOffersPacket_ = ClientboundMerchantOffersPacket;
    class SmokingRecipe extends Internal.AbstractCookingRecipe {
        constructor($$0: ResourceLocation_, $$1: string, $$2: Internal.CookingBookCategory_, $$3: Internal.Ingredient_, $$4: Internal.ItemStack_, $$5: number, $$6: number)
        isSpecial(): boolean;
        getGroup(): string;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getSchema(): Internal.RecipeSchema;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        getRemainingItems($$0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        get special(): boolean
        get group(): string
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type SmokingRecipe_ = SmokingRecipe;
    abstract class OperatorSideEffect {
        constructor($constructor_marker: any_)
        abstract performEffect(arg0: Internal.CastingVM_): void;
    }
    type OperatorSideEffect_ = OperatorSideEffect;
    abstract class CharsetEncoder {
        replaceWith(arg0: number[]): this;
        averageBytesPerChar(): number;
        canEncode(arg0: Internal.CharSequence_): boolean;
        charset(): Internal.Charset;
        onUnmappableCharacter(arg0: Internal.CodingErrorAction_): this;
        unmappableCharacterAction(): Internal.CodingErrorAction;
        onMalformedInput(arg0: Internal.CodingErrorAction_): this;
        replacement(): number[];
        reset(): this;
        isLegalReplacement(arg0: number[]): boolean;
        maxBytesPerChar(): number;
        encode(arg0: Internal.CharBuffer_, arg1: Internal.ByteBuffer_, arg2: boolean): Internal.CoderResult;
        encode(arg0: Internal.CharBuffer_): Internal.ByteBuffer;
        flush(arg0: Internal.ByteBuffer_): Internal.CoderResult;
        malformedInputAction(): Internal.CodingErrorAction;
        canEncode(arg0: string): boolean;
    }
    type CharsetEncoder_ = CharsetEncoder;
    class BarnaclesBlock extends Internal.MultifaceBlock implements Internal.SimpleWaterloggedBlock {
        constructor(p_153282_: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BarnaclesBlock_ = BarnaclesBlock;
    interface UnionLayout extends Internal.GroupLayout {
        sequenceLayout(arg0: number, arg1: Internal.MemoryLayout_): Internal.SequenceLayout;
        abstract toString(): string;
        sequenceLayout(arg0: Internal.MemoryLayout_): Internal.SequenceLayout;
        abstract name(): Internal.Optional<string>;
        withName(arg0: string): Internal.GroupLayout;
        byteOffset(...arg0: any_[]): number;
        abstract byteSize(): number;
        withByteAlignment(arg0: number): Internal.MemoryLayout;
        structLayout(...arg0: Internal.MemoryLayout_[]): Internal.StructLayout;
        abstract hashCode(): number;
        select(...arg0: any_[]): Internal.MemoryLayout;
        sliceHandle(...arg0: any_[]): Internal.MethodHandle;
        paddingLayout(arg0: number): Internal.PaddingLayout;
        varHandle(...arg0: any_[]): Internal.VarHandle;
        abstract byteAlignment(): number;
        byteOffsetHandle(...arg0: any_[]): Internal.MethodHandle;
        unionLayout(...arg0: Internal.MemoryLayout_[]): this;
        withoutName(): Internal.GroupLayout;
        abstract equals(arg0: any): boolean;
        abstract memberLayouts(): Internal.List<Internal.MemoryLayout>;
    }
    type UnionLayout_ = UnionLayout;
    class WillowLeavesBlock extends Internal.LeavesBlock {
        constructor(p_273704_: Internal.BlockBehaviour$Properties_)
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<Internal.ItemStack>;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly MOSSY: Internal.BooleanProperty;
    }
    type WillowLeavesBlock_ = WillowLeavesBlock;
    class BooleanSettingEntry extends Internal.SettingEntry<boolean> {
        constructor(key: string, guiKey: string, defaultValue: boolean, config: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.Config_, tooltip: net.minecraft.network.chat.Component_)
        constructor(key: string, defaultValue: boolean, config: dev.lambdaurora.lambdynlights.shadow.nightconfig.core.Config_, tooltip: net.minecraft.network.chat.Component_)
        withOnSet(arg0: Internal.Consumer_<any>): Internal.SettingEntry<any>;
    }
    type BooleanSettingEntry_ = BooleanSettingEntry;
    class SimpleFoiledItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type SimpleFoiledItem_ = SimpleFoiledItem;
    class TabStop implements Internal.Serializable {
        constructor(arg0: number)
        constructor(arg0: number, arg1: number, arg2: number)
        getPosition(): number;
        getLeader(): number;
        getAlignment(): number;
        get position(): number
        get leader(): number
        get alignment(): number
        static readonly ALIGN_RIGHT: 1;
        static readonly ALIGN_CENTER: 2;
        static readonly LEAD_NONE: 0;
        static readonly LEAD_EQUALS: 5;
        static readonly ALIGN_DECIMAL: 4;
        static readonly ALIGN_LEFT: 0;
        static readonly LEAD_DOTS: 1;
        static readonly ALIGN_BAR: 5;
        static readonly LEAD_HYPHENS: 2;
        static readonly LEAD_THICKLINE: 4;
        static readonly LEAD_UNDERLINE: 3;
    }
    type TabStop_ = TabStop;
    class DataInputStream extends Internal.FilterInputStream implements Internal.DataInput {
        constructor(arg0: Internal.InputStream_)
        readByte(): number;
        readFully(arg0: number[], arg1: number, arg2: number): void;
        readUnsignedByte(): number;
        readUnsignedShort(): number;
        readLong(): number;
        readFully(arg0: number[]): void;
        readDouble(): number;
        readInt(): number;
        readFloat(): number;
        readBoolean(): boolean;
        skipBytes(arg0: number): number;
        /**
         * @deprecated
        */
        readLine(): string;
        readShort(): number;
        readUTF(): string;
        static readUTF(arg0: Internal.DataInput_): string;
        readChar(): string;
    }
    type DataInputStream_ = DataInputStream;
    interface IHasCustomOutline {
        drawLine(vb: Internal.VertexConsumer_, ms: Internal.PoseStack_, x1: number, y1: number, z1: number, x2: number, y2: number, z2: number): void;
        abstract customOutline(arg0: Internal.PoseStack_, arg1: Internal.VertexConsumer_, arg2: Internal.BlockState_): void;
        drawLineWithAxisOffset(vb: Internal.VertexConsumer_, ms: Internal.PoseStack_, x1: number, y1: number, z1: number, x2: number, y2: number, z2: number, offset: number, axis: Internal.Direction$Axis_): void;
        abstract matrixRotation(arg0: Internal.PoseStack_, arg1: Internal.BlockState_): void;
    }
    type IHasCustomOutline_ = IHasCustomOutline;
    class CrystalshotItem extends Internal.ArrowItem implements Internal.InfiniteArrowItem {
        constructor(props: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isInfinite(stack: Internal.ItemStack_, bow: Internal.ItemStack_, player: Internal.Player_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        static withVariant(variant: string, size: number): Internal.ItemStack;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly RANDOM_VARIANTS: ["amethyst", "earthslime", "skyslime", "ichor", "enderslime", "quartz"];
    }
    type CrystalshotItem_ = CrystalshotItem;
    class PackageAddressDisplaySource extends Internal.SingleLineDisplaySource {
        constructor()
    }
    type PackageAddressDisplaySource_ = PackageAddressDisplaySource;
    class ClientboundSetScorePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.ServerScoreboard$Method_, $$1: string, $$2: string, $$3: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        getOwner(): string;
        write($$0: Internal.FriendlyByteBuf_): void;
        getScore(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        getObjectiveName(): string;
        getMethod(): Internal.ServerScoreboard$Method;
        get owner(): string
        get score(): number
        get skippable(): boolean
        get objectiveName(): string
        get method(): Internal.ServerScoreboard$Method
    }
    type ClientboundSetScorePacket_ = ClientboundSetScorePacket;
    class MushroomBlockBOP extends Internal.MushroomBlock implements Internal.BonemealableBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type MushroomBlockBOP_ = MushroomBlockBOP;
    interface ColorResolver {
        abstract getColor(arg0: Internal.Biome_, arg1: number, arg2: number): number;
        (arg0: Internal.Biome, arg1: number, arg2: number): number;
    }
    type ColorResolver_ = ColorResolver;
    interface ChannelHandlerContext extends Internal.ChannelOutboundInvoker, io.netty.util.AttributeMap, Internal.ChannelInboundInvoker {
        abstract connect(arg0: Internal.SocketAddress_, arg1: Internal.SocketAddress_, arg2: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract pipeline(): Internal.ChannelPipeline;
        abstract deregister(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract executor(): Internal.EventExecutor;
        abstract fireChannelReadComplete(): this;
        /**
         * @deprecated
        */
        abstract attr<T>(arg0: Internal.AttributeKey_<T>): io.netty.util.Attribute<T>;
        abstract write(arg0: any): Internal.ChannelFuture;
        abstract writeAndFlush(arg0: any): Internal.ChannelFuture;
        abstract disconnect(): Internal.ChannelFuture;
        abstract isRemoved(): boolean;
        abstract close(): Internal.ChannelFuture;
        abstract write(arg0: any, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract connect(arg0: Internal.SocketAddress_): Internal.ChannelFuture;
        abstract connect(arg0: Internal.SocketAddress_, arg1: Internal.SocketAddress_): Internal.ChannelFuture;
        abstract deregister(): Internal.ChannelFuture;
        abstract fireChannelRegistered(): this;
        abstract fireChannelInactive(): this;
        abstract disconnect(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract read(): this;
        abstract handler(): Internal.ChannelHandler;
        abstract newFailedFuture(arg0: Internal.Throwable_): Internal.ChannelFuture;
        abstract alloc(): Internal.ByteBufAllocator;
        abstract close(arg0: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract newSucceededFuture(): Internal.ChannelFuture;
        abstract fireExceptionCaught(arg0: Internal.Throwable_): this;
        abstract newProgressivePromise(): Internal.ChannelProgressivePromise;
        abstract flush(): this;
        abstract fireChannelUnregistered(): this;
        abstract name(): string;
        abstract channel(): io.netty.channel.Channel;
        abstract bind(arg0: Internal.SocketAddress_, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract writeAndFlush(arg0: any, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract bind(arg0: Internal.SocketAddress_): Internal.ChannelFuture;
        abstract fireChannelRead(arg0: any): this;
        abstract connect(arg0: Internal.SocketAddress_, arg1: Internal.ChannelPromise_): Internal.ChannelFuture;
        abstract fireUserEventTriggered(arg0: any): this;
        abstract fireChannelWritabilityChanged(): this;
        /**
         * @deprecated
        */
        abstract hasAttr<T>(arg0: Internal.AttributeKey_<T>): boolean;
        abstract voidPromise(): Internal.ChannelPromise;
        abstract fireChannelActive(): this;
        abstract newPromise(): Internal.ChannelPromise;
        get removed(): boolean
    }
    type ChannelHandlerContext_ = ChannelHandlerContext;
    class TrunkVineDecorator extends Internal.TreeDecorator {
        constructor()
        static readonly CODEC: Internal.Codec<Internal.TrunkVineDecorator>;
        static readonly INSTANCE: Internal.TrunkVineDecorator;
    }
    type TrunkVineDecorator_ = TrunkVineDecorator;
    interface PositionTracker {
        abstract isVisibleBy(arg0: Internal.LivingEntity_): boolean;
        abstract currentBlockPosition(): BlockPos;
        abstract currentPosition(): Vec3d;
    }
    type PositionTracker_ = PositionTracker;
    class SectionStorage <R> implements Internal.AutoCloseable, Internal.RegionBasedStorageSectionExtended<any> {
        constructor($$0: Internal.Path_, $$1: Internal.Function_<Internal.Runnable, Internal.Codec<R>>, $$2: Internal.Function_<Internal.Runnable, R>, $$3: Internal.DataFixer_, $$4: any_, $$5: boolean, $$6: Internal.RegistryAccess_, $$7: Internal.LevelHeightAccessor_)
        close(): void;
        flush($$0: Internal.ChunkPos_): void;
        getOrLoad($$0: number): Internal.Optional<R>;
        getWithinChunkColumn(chunkX: number, chunkZ: number): Internal.Stream<any>;
        getInChunkColumn(chunkX: number, chunkZ: number): Internal.Iterable<any>;
        hasWork(): boolean;
    }
    type SectionStorage_<R> = SectionStorage<R>;
    class TextColor implements dev.latvian.mods.rhino.mod.util.color.Color {
        static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
        getArgbJS(): number;
        specialEquals(o: any, shallow: boolean): boolean;
        static fromRgb($$0: number): Internal.TextColor;
        getRgbJS(): number;
        formatValue(): string;
        getSerializeJS(): string;
        static parseColor($$0: string): Internal.TextColor;
        serialize(): string;
        static fromLegacyFormat($$0: Internal.ChatFormatting_): Internal.TextColor;
        createTextColorJS(): this;
        getValue(): number;
        getHexJS(): string;
        getFireworkColorJS(): number;
        get argbJS(): number
        get rgbJS(): number
        get serializeJS(): string
        get value(): number
        get hexJS(): string
        get fireworkColorJS(): number
        static readonly CODEC: Internal.Codec<Internal.TextColor>;
    }
    type TextColor_ = TextColor;
    class CustomBossEvent extends Internal.ServerBossEvent {
        constructor($$0: ResourceLocation_, $$1: net.minecraft.network.chat.Component_)
        setValue($$0: number): void;
        onPlayerConnect($$0: Internal.ServerPlayer_): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        save(): Internal.CompoundTag;
        setPlayers($$0: Internal.Collection_<Internal.ServerPlayer>): boolean;
        static load($$0: Internal.CompoundTag_, $$1: ResourceLocation_): Internal.CustomBossEvent;
        addOfflinePlayer($$0: Internal.UUID_): void;
        getMax(): number;
        getTextId(): ResourceLocation;
        setMax($$0: number): void;
        getValue(): number;
        onPlayerDisconnect($$0: Internal.ServerPlayer_): void;
        set value($$0: number)
        get displayName(): net.minecraft.network.chat.Component
        set players($$0: Internal.Collection_<Internal.ServerPlayer>)
        get max(): number
        get textId(): ResourceLocation
        set max($$0: number)
        get value(): number
    }
    type CustomBossEvent_ = CustomBossEvent;
    class ProbabilityFeatureConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: number)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        readonly probability: number;
        static readonly CODEC: Internal.Codec<Internal.ProbabilityFeatureConfiguration>;
    }
    type ProbabilityFeatureConfiguration_ = ProbabilityFeatureConfiguration;
    interface Float2LongFunction extends Internal.DoubleToLongFunction, it.unimi.dsi.fastutil.Function<number, number> {
        andThenShort(arg0: Internal.Long2ShortFunction_): Internal.Float2ShortFunction;
        put(arg0: number, arg1: number): number;
        composeByte(arg0: Internal.Byte2FloatFunction_): Internal.Byte2LongFunction;
        composeChar(arg0: Internal.Char2FloatFunction_): Internal.Char2LongFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        andThenLong(arg0: Internal.Long2LongFunction_): this;
        composeInt(arg0: Internal.Int2FloatFunction_): Internal.Int2LongFunction;
        andThenByte(arg0: Internal.Long2ByteFunction_): Internal.Float2ByteFunction;
        composeShort(arg0: Internal.Short2FloatFunction_): Internal.Short2LongFunction;
        andThenDouble(arg0: Internal.Long2DoubleFunction_): Internal.Float2DoubleFunction;
        composeReference<T>(arg0: Internal.Reference2FloatFunction_<T>): Internal.Reference2LongFunction<T>;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        andThenObject<T>(arg0: Internal.Long2ObjectFunction_<T>): Internal.Float2ObjectFunction<T>;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeFloat(arg0: Internal.Float2FloatFunction_): this;
        containsKey(arg0: number): boolean;
        composeLong(arg0: Internal.Long2FloatFunction_): Internal.Long2LongFunction;
        andThenChar(arg0: Internal.Long2CharFunction_): Internal.Float2CharFunction;
        defaultReturnValue(): number;
        getOrDefault(arg0: number, arg1: number): number;
        composeObject<T>(arg0: Internal.Object2FloatFunction_<T>): Internal.Object2LongFunction<T>;
        /**
         * @deprecated
        */
        applyAsLong(arg0: number): number;
        apply(arg0: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        andThenInt(arg0: Internal.Long2IntFunction_): Internal.Float2IntFunction;
        composeDouble(arg0: Internal.Double2FloatFunction_): Internal.Double2LongFunction;
        andThenFloat(arg0: Internal.Long2FloatFunction_): Internal.Float2FloatFunction;
        andThenReference<T>(arg0: Internal.Long2ReferenceFunction_<T>): Internal.Float2ReferenceFunction<T>;
        size(): number;
        remove(arg0: number): number;
        abstract get(arg0: number): number;
        clear(): void;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        defaultReturnValue(arg0: number): void;
        (arg0: number): number;
    }
    type Float2LongFunction_ = Float2LongFunction;
    interface TagMatchTestAccessor {
        abstract getTag(): Internal.TagKey<Internal.Block>;
        get tag(): Internal.TagKey<Internal.Block>
        (): Internal.TagKey_<Internal.Block>;
    }
    type TagMatchTestAccessor_ = TagMatchTestAccessor;
    class BuildersTeaItem extends Internal.Item {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BuildersTeaItem_ = BuildersTeaItem;
    class Cleaner {
        static create(): Internal.Cleaner;
        static create(arg0: Internal.ThreadFactory_): Internal.Cleaner;
        register(arg0: any, arg1: Internal.Runnable_): Internal.Cleaner$Cleanable;
    }
    type Cleaner_ = Cleaner;
    class ItemNameAttribute$Type implements Internal.ItemAttributeType {
        constructor()
        getAllAttributes(stack: Internal.ItemStack_, level: Internal.Level_): Internal.List<Internal.ItemAttribute>;
        createAttribute(): Internal.ItemAttribute;
    }
    type ItemNameAttribute$Type_ = ItemNameAttribute$Type;
    abstract class LecternBookItem extends Internal.TooltipItem implements Internal.ILecternBookItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static interactWithBlock(player: Internal.Player_, world: Internal.Level_, hand: Internal.InteractionHand_, hitResult: Internal.BlockHitResult_): Internal.InteractionResult;
        openLecternScreen(world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, book: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        abstract openLecternScreenClient(arg0: BlockPos_, arg1: Internal.ItemStack_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type LecternBookItem_ = LecternBookItem;
    class AkashicCopyEffect implements Internal.PrestidigitationEffect {
        constructor()
        effectEntity(env: Internal.CastingEnvironment_, entity: Internal.Entity_): void;
        effectBlock(env: Internal.CastingEnvironment_, position: BlockPos_): void;
    }
    type AkashicCopyEffect_ = AkashicCopyEffect;
    abstract class AbstractBuilder <R, T extends R, P, S extends Internal.AbstractBuilder<R, T, P, S>> implements Internal.Builder<R, T, P, S> {
        constructor(owner: Internal.AbstractRegistrate_<any>, parent: P, name: string, callback: Internal.BuilderCallback_, registryKey: Internal.ResourceKey_<Internal.Registry<R>>)
        lang(langKeyProvider: com.tterrag.registrate.util.nullness.NonNullFunction_<T, string>, name: string): S;
        getRegistryKey(): Internal.ResourceKey<Internal.Registry<R>>;
        tag<TP extends Internal.TagsProvider<R> & Internal.RegistrateTagsProvider<R>>(type: Internal.ProviderType_<TP>, ...tags: Internal.TagKey_<R>[]): S;
        onRegister(callback: com.tterrag.registrate.util.nullness.NonNullConsumer_<T>): S;
        static of<T>(sup: Internal.Supplier_<T>, errorMsg: Internal.NonNullSupplier_<string>): Internal.NonNullSupplier<T>;
        static of<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        transform<R2, T2 extends R2, P2, S2 extends Internal.Builder<R2, T2, P2, S2>>(func: com.tterrag.registrate.util.nullness.NonNullFunction_<S, S2>): S2;
        lang(langKeyProvider: com.tterrag.registrate.util.nullness.NonNullFunction_<T, string>): S;
        addMiscData<D extends Internal.RegistrateProvider>(type: Internal.ProviderType_<D>, cons: com.tterrag.registrate.util.nullness.NonNullConsumer_<D>): S;
        getParent(): P;
        getOwner(): Internal.AbstractRegistrate<any>;
        setData<D extends Internal.RegistrateProvider>(type: Internal.ProviderType_<D>, cons: Internal.NonNullBiConsumer_<Internal.DataGenContext<R, T>, D>): S;
        static lazy<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        lazy(): Internal.NonNullSupplier<Internal.RegistryEntry<T>>;
        asSupplier(): Internal.NonNullSupplier<T>;
        onRegisterAfter<OR>(dependencyType: Internal.ResourceKey_<Internal.Registry<OR>>, callback: com.tterrag.registrate.util.nullness.NonNullConsumer_<T>): S;
        getName(): string;
        register(): Internal.RegistryEntry<T>;
        removeTag<TP extends Internal.TagsProvider<R> & Internal.RegistrateTagsProvider<R>>(type: Internal.ProviderType_<TP>, ...tags: Internal.TagKey_<R>[]): S;
        getEntry(): T;
        get(): Internal.RegistryEntry<T>;
        build(): P;
        get registryKey(): Internal.ResourceKey<Internal.Registry<R>>
        get parent(): P
        get owner(): Internal.AbstractRegistrate<any>
        get name(): string
        get entry(): T
    }
    type AbstractBuilder_<R, T extends R, P, S extends Internal.AbstractBuilder<R, T, P, S>> = AbstractBuilder<R, T, P, S>;
}
declare namespace io.wispforest.owo.ui.core {
    class Color extends Internal.Record implements Internal.Animatable<io.wispforest.owo.ui.core.Color> {
        constructor(red: number, green: number, blue: number)
        constructor(red: number, green: number, blue: number, alpha: number)
        interpolate(arg0: Internal.Animatable_<any>, arg1: number): Internal.Animatable<any>;
        rgb(): number;
        hsv(): number[];
        static ofHsv(hue: number, saturation: number, value: number, alpha: number): io.wispforest.owo.ui.core.Color;
        asHexString(includeAlpha: boolean): string;
        alpha(): number;
        static ofFormatting(formatting: Internal.ChatFormatting_): io.wispforest.owo.ui.core.Color;
        green(): number;
        static parseAndPack(node: org.w3c.dom.Node_): number;
        argb(): number;
        blue(): number;
        static ofHsv(hue: number, saturation: number, value: number): io.wispforest.owo.ui.core.Color;
        red(): number;
        static parse(node: org.w3c.dom.Node_): io.wispforest.owo.ui.core.Color;
        static ofDye(dyeColor: Internal.DyeColor_): io.wispforest.owo.ui.core.Color;
        static ofRgb(rgb: number): io.wispforest.owo.ui.core.Color;
        static ofArgb(argb: number): io.wispforest.owo.ui.core.Color;
        interpolate(next: io.wispforest.owo.ui.core.Color_, delta: number): this;
        static readonly GREEN: io.wispforest.owo.ui.core.Color;
        static readonly BLACK: io.wispforest.owo.ui.core.Color;
        static readonly BLUE: io.wispforest.owo.ui.core.Color;
        static readonly RED: io.wispforest.owo.ui.core.Color;
        static readonly WHITE: io.wispforest.owo.ui.core.Color;
    }
    type Color_ = Color;
}
declare namespace io.github.fabricators_of_create.porting_lib.entity.extensions {
    interface AbstractMinecartExtensions {
        moveMinecartOnRail(pos: BlockPos_): void;
        getMaxSpeedOnRail(): number;
        getCurrentRailPos(): BlockPos;
        get maxSpeedOnRail(): number
        get currentRailPos(): BlockPos
    }
    type AbstractMinecartExtensions_ = AbstractMinecartExtensions;
}
declare namespace net.fabricmc.fabric.mixin.networking.accessor {
    interface ServerPlayNetworkHandlerAccessor {
        abstract getConnection(): Internal.Connection;
        get connection(): Internal.Connection
        (): Internal.Connection_;
    }
    type ServerPlayNetworkHandlerAccessor_ = ServerPlayNetworkHandlerAccessor;
}
declare namespace net.createmod.catnip.data {
    class TriState extends Internal.Enum<net.createmod.catnip.data.TriState> {
        static values(): net.createmod.catnip.data.TriState[];
        isTrue(): boolean;
        getValue(): boolean;
        isFalse(): boolean;
        static valueOf(name: string): net.createmod.catnip.data.TriState;
        isDefault(): boolean;
        get "true"(): boolean
        get value(): boolean
        get "false"(): boolean
        get "default"(): boolean
        static readonly TRUE: net.createmod.catnip.data.TriState;
        static readonly FALSE: net.createmod.catnip.data.TriState;
        static readonly DEFAULT: net.createmod.catnip.data.TriState;
    }
    type TriState_ = "false" | TriState | "default" | "true";
}
declare namespace com.simibubi.create.foundation.utility.fabric {
    interface StructureBlockEntityExtensions {
        abstract create$markGameTest(): void;
        (): void;
    }
    type StructureBlockEntityExtensions_ = StructureBlockEntityExtensions;
}
declare namespace com.agricraft.agricraft.common.block {
    class CropBlock extends Internal.Block implements Internal.SimpleFluidloggedBlock, Internal.EntityBlock, Internal.BonemealableBlock {
        constructor()
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        blockStatePlant(state: Internal.BlockState_): Internal.BlockState;
        canPlaceLiquid(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, fluid: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock(level: Internal.LevelAccessor_, pos: BlockPos_, state: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        isBonemealSuccess(level: Internal.Level_, random: Internal.RandomSource_, pos: BlockPos_, state: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        static spawnItem(level: Internal.Level_, pos: BlockPos_, stack: Internal.ItemStack_): void;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal(level: Internal.ServerLevel_, random: Internal.RandomSource_, pos: BlockPos_, state: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget(level: Internal.LevelReader_, pos: BlockPos_, state: Internal.BlockState_, isClient: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static removeCropSticks(level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_): Internal.InteractionResultHolder<Internal.CropStickVariant>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        blockStateCropStick(state: Internal.BlockState_, variant: Internal.CropStickVariant_): Internal.BlockState;
        placeLiquid(level: Internal.LevelAccessor_, pos: BlockPos_, state: Internal.BlockState_, fluidState: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        static applyCropSticks(level: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_, variant: Internal.CropStickVariant_): Internal.InteractionResult;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly CROP_STATE: Internal.EnumProperty<Internal.CropState>;
        static readonly CROP_STICKS: Internal.ArrayVoxelShape;
        static readonly SINGLE_STICKS: Internal.ArrayVoxelShape;
        static readonly STICK_VARIANT: Internal.EnumProperty<Internal.CropStickVariant>;
        static readonly CROSS_STICKS: Internal.ArrayVoxelShape;
        static readonly LIGHT: Internal.IntegerProperty;
    }
    type CropBlock_ = CropBlock;
}
